package com.yeejoin.precontrol.common.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 用户app菜单配置表
 *
 * @author duanwei
 * @date 2021-02-22
 */
@Data
@Accessors(chain = true)
@TableName("rpm_app_menu_config")
@ApiModel(value = "AppMenuConfigVo", description = "用户app菜单配置表")
public class AppMenuConfigVo {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "用户id")
    private String userId;

    @ApiModelProperty(value = "菜单key")
    private String menuKey;

    @ApiModelProperty(value = "菜单描述")
    private String menuLabel;

    @ApiModelProperty(value = "图标")
    private String menuIcon;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "是否必须", notes = "初始化的前4个不可删除,子定义的可删除")
    private Boolean isMust;
    @ApiModelProperty(value = "跳转页面url",notes = "跳转页面url")
    private String page;

    @ApiModelProperty(value = "是否自定义功能",notes = "是否自定义功能")
    private Boolean isUsed;


}
