package com.yeejoin.amos.boot.module.jg.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 移装变更登记登记
 *
 * @author system_generator
 * @date 2023-12-20
 */
@Data
@EqualsAndHashCode (callSuper = true)
@ApiModel (value = "JgChangeRegistrationTransferDto", description = "移装变更登记登记")
public class JgChangeRegistrationTransferDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty (value = "设备监管码")
    private String supervisoryCode;

    @ApiModelProperty (value = "使用单位名称")
    private String useUnitName;

    @ApiModelProperty (value = "申请编号")
    private String applyNo;

    @ApiModelProperty (value = "办理状态")
    private String auditStatus;

    @ApiModelProperty (value = "登记机构")
    private String receiveOrgName;

    @ApiModelProperty (value = "检验单位")
    private String inspectUnitName;

    @ApiModelProperty (value = "检验结果照片")
    private String inspectResultPhoto;

    @ApiModelProperty (value = "检验结果")
    private String inspectResult;

    @ApiModelProperty (value = "终审通过时间")
    private Date auditPassDate;

    @ApiModelProperty (value = "登记类别")
    private String regType;

    @ApiModelProperty (value = "注册登记日期")
    private Date regDate;

    @ApiModelProperty (value = "注册登记人员ID")
    private String regPersonId;

    @ApiModelProperty (value = "注册登记人员")
    private String regPersonName;

    @ApiModelProperty (value = "安装单位名称")
    private String installUnitName;

    @ApiModelProperty (value = "状态")
    private String status;

    @ApiModelProperty (value = "备注")
    private String remark;

    @ApiModelProperty (value = "创建人ID")
    private String createUserId;

    @ApiModelProperty (value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date createDate;

    @ApiModelProperty (value = "录入单位统一信用代码")
    private String inputUnitNo;

    @ApiModelProperty (value = "使用登记编号")
    private String useRegistrationCode;

    @ApiModelProperty(value = "96333识别码")
    private String code96333;

    @ApiModelProperty (value = "流程实例id")
    private String instanceId;

    @ApiModelProperty (value = "使用单位统一信用代码")
    private String useUnitCreditCode;

    @ApiModelProperty (value = "检验机构统一信用代码")
    private String inspectUnitCreditCode;

    @ApiModelProperty (value = "流程执行顺序标识")
    private String executeSequence;

    @ApiModelProperty (value = "登记机构代码")
    private String receiveOrgCode;

    @ApiModelProperty (value = "登记机构公司代码")
    private String receiveCompanyCode;

    @ApiModelProperty (value = "下一执行节点ids")
    private String nextExecutorIds;

    @ApiModelProperty (value = "移装告知申请id")
    private String reformNoticeId;

    @ApiModelProperty (value = "任务发起人id")
    private String promoter;

    @ApiModelProperty (value = "设备类别")
    private String equCategory;

    @ApiModelProperty (value = "设备代码")
    private String equCode;

    @ApiModelProperty (value = "当前登录人角色Ids")
    private List<String> roleIds;

    private  String dataType;
    private String unitCode;

    @ApiModelProperty(value = "申请日期，接收查询参数")
    private String applicationDate;

    @ApiModelProperty("设备品种")
    private String equDefine;

    @ApiModelProperty(value = "设备种类")
    private String equList;


    @ApiModelProperty (value = "下一节点可执行人")
    private String nextExecuteUserIds;

    @ApiModelProperty(value = "设备移装完整详细地址")
    private String fullAddress;

    @ApiModelProperty(value = "设备名称")
    private String productName;

    @ApiModelProperty(value = "设备移装完整详细地址")
    private String allAddress;

    @ApiModelProperty(value = " 单位内部编号")
    private String innerCode;

    @ApiModelProperty(value = " 转办后执行人的Id逗号分割")
    private String transferToUserIds;


}
