package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface DPStatisticsMapper {

    List<Map<String, Object>> maintenanceCountTopTen(@Param("dpFilterParamDto") DPFilterParamDto dpFilterParamDto, @Param("regionCodeList") List<Integer> regionCodeList);
    List<Map<String, Object>> maintenanceCount(@Param("dpFilterParamDto") DPFilterParamDto dpFilterParamDto, @Param("regionCodeList") List<Integer> regionCodeList);

    List<Map<String, Object>> installEquCount(@Param("cityCode") String cityCode,@Param("startTime") String startTime);

    List<Map<String, Object>> maintenanceEquCount(@Param("cityCode") String cityCode,@Param("startTime") String startTime);

    List<Map<String, Object>> reformEquCount(@Param("cityCode") String cityCode,@Param("startTime") String startTime);

    List<Map<String, Object>> transferEquCount(@Param("cityCode") String cityCode,@Param("startTime") String startTime);



    List<Map<String, Object>> useEquCount(@Param("cityCode") String cityCode,@Param("startTime") String startTime);

    List<Map<String, Object>> changeReformEquCount(@Param("cityCode") String cityCode,@Param("startTime") String startTime);

    List<Map<String, Object>> changeTransferEquCount(@Param("cityCode") String cityCode,@Param("startTime") String startTime);

    List<Map<String, Object>> changeUnitEquCount(@Param("cityCode") String cityCode,@Param("startTime") String startTime);

    List<Map<String, Object>> vehicleEquCount(@Param("cityCode") String cityCode,@Param("startTime") String startTime);

    List<Map<String, Object>> newRegEquCountByMonth(@Param("cityCode") String cityCode);

    List<Map<String, Object>> newVehicleEquCountByMonth(@Param("cityCode") String cityCode);

    List<Map<String, Object>> newRegEquCountByYear(@Param("cityCode") String cityCode);

    List<Map<String, Object>> newVehicleEquCountByYear(@Param("cityCode") String cityCode);

    String newVehicleCountByYear(@Param("cityCode") String cityCode);
    String newVehicleCountByMonth(@Param("cityCode") String cityCode);
    List<Map<String, Object>> installCountByOrgCodes(@Param("orgCodes") List<String> orgCodes);

    List<Map<String, Object>> maintenanceNoticeCountByOrgCodes(@Param("orgCodes") List<String> orgCodes);

    List<Map<String, Object>> reformCountByOrgCodes(@Param("orgCodes") List<String> orgCodes);

    List<Map<String, Object>> transferCountByOrgCodes(@Param("orgCodes") List<String> orgCodes);

    List<Map<String, Object>> useCountByOrgCodes(@Param("orgCodes") List<String> orgCodes);

    List<Map<String, Object>> vehicleCountByOrgCodes(@Param("orgCodes") List<String> orgCodes);

    List<Map<String, Object>> changeNameCountByOrgCodes(@Param("orgCodes") List<String> orgCodes);

    List<Map<String, Object>> changeReformCountByOrgCodes(@Param("orgCodes") List<String> orgCodes);

    List<Map<String, Object>> changeTransferCountByOrgCodes(@Param("orgCodes") List<String> orgCodes);

    List<Map<String, Object>> changeUnitCountByOrgCodes(@Param("orgCodes") List<String> orgCodes);

    List<Map<String, Object>> changeVehicleCountByOrgCodes(@Param("orgCodes") List<String> orgCodes);

    List<Map<String, Object>> disableCountByOrgCodes(@Param("orgCodes") List<String> orgCodes);

    List<Map<String, Object>> cancelCountByOrgCodes(@Param("orgCodes") List<String> orgCodes);

    long certificateCountByOrgCode(@Param("orgCode") String orgCode);

    long useCountByOrgCode(@Param("orgCode") String orgCode);

    Long over15yearsCount(@Param("orgCode") String orgCode, @Param("time") String time);

    Long constructionNoticeCount(@Param("orgCode") String orgCode);

    Long changeCountByOrgCode(@Param("orgCode") String orgCode);

    List<Map<String, Object>> selectNoticeList(@Param("orgCode") String orgCode, @Param("time") String time);

    List<Map<String, Object>> selectNoticeCountTopTen(@Param("orgCode") String orgCode, @Param("time") String time);
}
