package com.yeejoin.amos.boot.module.statistics.api.mapper;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-13
 */
@Mapper
public interface JYJCStatisticsMapper {

    /**
     * 检验机构总量统计
     *
     * @param orgCode    区域对应的orgCode
     * @param regionCode 区域行政区划编码
     * @return 检验机构总量
     */
    Long countAllRegInspectCompany(@Param("orgCode") String orgCode, @Param("regionCode") String regionCode);

    /**
     * 第三方检验机构数量（除去法定名单就是第三方）
     *
     * @param orgCode    区域对应的orgCode
     * @param legalCmc   法定的检验机构名单
     * @param regionCode 区域行政区划编码
     * @return 检验机构总量
     */
    Long countAllRegThirdInspectCompany(@Param("orgCode") String orgCode, @Param("legalCmc") List<String> legalCmc, @Param("regionCode") String regionCode);

    /**
     * 业务开通机构数量
     *
     * @param orgCode    区域对应的orgCode
     * @param regionCode 区域行政区划编码
     * @return 检验机构总量
     */
    Long countAllOpenBizInspectCompany(@Param("orgCode") String orgCode, @Param("regionCode") String regionCode);
}
