package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 派遣单
 *
 * @author kongfm
 * @date 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_dispatch_paper")
public class DispatchPaper extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 警情id
     */
	@TableField("alert_id")
    private Long alertId;

    /**
     * 组织code
     */
	@TableField("org_code")
    private String orgCode;

    /**
     * 完成状态
     */
	@TableField("paper_status")
    private String paperStatus;

    /**
     * 完成状态code
     */
	@TableField("paper_status_code")
    private String paperStatusCode;

    /**
     * 处置环节
     */
	@TableField("process_status")
    private String processStatus;

    /**
     * 处置环节code
     */
	@TableField("process_status_code")
    private String processStatusCode;

    /**
     * 警情类型
     */
	@TableField("alert_type")
    private String alertType;

    /**
     * 警情类型code
     */
	@TableField("alert_code")
    private String alertCode;

    /**
     * 派遣时间
     */
	@TableField("dispatch_time")
    private Date dispatchTime;

    /**
     * 派遣人id
     */
	@TableField("send_user_id")
    private String sendUserId;

    /**
     * 派遣人名称
     */
	@TableField("send_user_name")
    private String sendUserName;

    /**
     * 使用单位id
     */
	@TableField("use_org_id")
    private Long useOrgId;

    /**
     * 维保单位id 困人救援时为三级响应单位id
     */
	@TableField("repair_org_id")
    private Long repairOrgId;

    /**
     * 维保单位社会信用代码 
     */
	@TableField("repair_org_credit_code")
    private String repairOrgCreditCode;

    /**
     * 使用单位任务id
     */
	@TableField("use_org_task_id")
    private Long useOrgTaskId;

    /**
     * 维保单位任务id/ 困人救援时为三级调派的任务id 
     */
	@TableField("repair_org_task_id")
    private Long repairOrgTaskId;

    /**
     * 维修完成时间/维保处置完成时间
     */
	@TableField("feedback_finish_time")
    private Date feedbackFinishTime;

    /**
     * 维修投诉反馈方式code
     */
	@TableField("feedback_code")
    private String feedbackCode;

    /**
     * 维修投诉反馈方式
     */
	@TableField("feedback_type")
    private String feedbackType;

    /**
     * 维修投诉回访时间
     */
	@TableField("feedback_time")
    private Date feedbackTime;

    /**
     * 维修投诉回访人id
     */
	@TableField("feedback_uid")
    private String feedbackUid;

    /**
     * 维修投诉回访人名称
     */
	@TableField("feedback_uname")
    private String feedbackUname;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 到达时间
     */
    @TableField("arrive_time")
    private Date arriveTime;

    /**
     * 处置时间
     */
    @TableField("deal_time")
    private Date dealTime;


    /**
     * 救援机构名称
     */
    @TableField("save_org_name")
    private String saveOrgName;

    /**
     * 维修单位名称
     */
    @TableField("repair_org_name")
    private String repairOrgName;

    /**
     * 维修人
     */
    @TableField("repair_user")
    private String repairUser;

    /**
     * 处置单位
     */
    @TableField("deal_org_name")
    private String dealOrgName;

    /**
     * 处置人
     */
    @TableField("deal_user")
    private String dealUser;

    /**
     * 到达反馈方式
     */
    @TableField("arrive_feedback_type")
    private String arriveFeedbackType;


    /**
     * 到达反馈方式code
     */
    @TableField("arrive_feedback_code")
    private String arriveFeedbackCode;

    /**
     * 救出时间-- 冗余字段便于查询
     */
    @TableField("save_time")
    private Date saveTime;
}
