package com.yeejoin.amos.boot.module.tcm.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tcm.biz.service.impl.TzsUserPermissionServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.TzsUserPermissionDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 用户资质信息表
 *
 * @author system_generator
 * @date 2024-08-27
 */
@RestController
@Api(tags = "用户资质信息表Api")
@RequestMapping(value = "/user-permission")
public class TzsUserPermissionController extends BaseController {

    @Autowired
    TzsUserPermissionServiceImpl tzsUserPermissionServiceImpl;

    /**
     * 新增用户资质信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增用户资质信息表", notes = "新增用户资质信息表")
	public ResponseModel<TzsUserPermissionDto> save(@RequestBody TzsUserPermissionDto model) {
	    model = tzsUserPermissionServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新用户资质信息表", notes = "根据sequenceNbr更新用户资质信息表")
	public ResponseModel<TzsUserPermissionDto> updateBySequenceNbrTzsUserPermission(@RequestBody TzsUserPermissionDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(tzsUserPermissionServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除用户资质信息表", notes = "根据sequenceNbr删除用户资质信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(tzsUserPermissionServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个用户资质信息表",  notes = "根据sequenceNbr查询单个用户资质信息表")
	public ResponseModel<TzsUserPermissionDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(tzsUserPermissionServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "用户资质信息表分页查询",  notes = "用户资质信息表分页查询")
	public ResponseModel<Page<TzsUserPermissionDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<TzsUserPermissionDto> page = new Page<TzsUserPermissionDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(tzsUserPermissionServiceImpl.queryForTzsUserPermissionPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "用户资质信息表列表全部数据查询",   notes = "用户资质信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<TzsUserPermissionDto>> selectForList() {
	    return ResponseHelper.buildResponse(tzsUserPermissionServiceImpl.queryForTzsUserPermissionList());
	}
}
