package com.yeejoin.amos.boot.module.jyjc.biz.event.listener.service;

import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResult;
import com.yeejoin.amos.boot.module.jyjc.biz.result.factory.ResultProcessorFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Slf4j
@RequiredArgsConstructor
public class InspectionResultProcessor {

    private final ResultProcessorFactory resultProcessorFactory;

    @Transactional(rollbackFor = Exception.class)
    public void process(JyjcInspectionResult jyjcInspectionResult) {
        resultProcessorFactory.getProcessor(jyjcInspectionResult.getEquList()).process(jyjcInspectionResult);
    }

}
