package com.yeejoin.amos.boot.module.ugp.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.SuperviseRuleServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.SuperviseRuleDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 监管区域规则表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "监管区域规则表Api")
@RequestMapping(value = "/supervise-rule")
public class SuperviseRuleController extends BaseController {

    @Autowired
    SuperviseRuleServiceImpl superviseRuleServiceImpl;

    /**
     * 新增监管区域规则表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增监管区域规则表", notes = "新增监管区域规则表")
	public ResponseModel<SuperviseRuleDto> save(@RequestBody SuperviseRuleDto model) {
	    model = superviseRuleServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新监管区域规则表", notes = "根据sequenceNbr更新监管区域规则表")
	public ResponseModel<SuperviseRuleDto> updateBySequenceNbrSuperviseRule(@RequestBody SuperviseRuleDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(superviseRuleServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除监管区域规则表", notes = "根据sequenceNbr删除监管区域规则表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(superviseRuleServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个监管区域规则表",  notes = "根据sequenceNbr查询单个监管区域规则表")
	public ResponseModel<SuperviseRuleDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(superviseRuleServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "监管区域规则表分页查询",  notes = "监管区域规则表分页查询")
	public ResponseModel<Page<SuperviseRuleDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<SuperviseRuleDto> page = new Page<SuperviseRuleDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(superviseRuleServiceImpl.queryForSuperviseRulePage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "监管区域规则表列表全部数据查询",   notes = "监管区域规则表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<SuperviseRuleDto>> selectForList() {
	    return ResponseHelper.buildResponse(superviseRuleServiceImpl.queryForSuperviseRuleList());
	}
}
