package com.yeejoin.amos.api.openapi.face.builder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.yeejoin.amos.api.openapi.face.orm.entity.*;

import java.util.List;
import java.util.stream.Collectors;

public class UniqueFieldsQueryBuilder implements QueryConditionBuilder{
    @Override
    public <T> void buildQueryWrapper(QueryWrapper<T> queryWrapper, List<T> entityList) {
        Assert.notEmpty(entityList, "error: entityList must not be empty");
        T entity = entityList.get(0); // 根据气瓶对接数据具体业务，每个接口都只包含一种类型，所以可根据其中一个元素来进行类型判断
        if (entity instanceof TmCylinderUnit) {
            List<TmCylinderUnit> unitList = (List<TmCylinderUnit>) entityList;
            queryWrapper.eq("app_id", unitList.stream().map(AbstractBaseEntity::getAppId).findFirst().get());
        }
        if (entity instanceof TmCylinderInfo) {
            List<TmCylinderInfo> infoList = (List<TmCylinderInfo>) entityList;
            queryWrapper.in("app_id", infoList.stream().map(AbstractBaseEntity::getAppId).collect(Collectors.toList()));
            queryWrapper.in("sequence_code", infoList.stream().map(TmCylinderInfo::getSequenceCode).collect(Collectors.toList()));
        }
        if (entity instanceof TmCylinderTags) {
            List<TmCylinderTags> tagsList = (List<TmCylinderTags>) entityList;
            queryWrapper.in("app_id", tagsList.stream().map(AbstractBaseEntity::getAppId).collect(Collectors.toList()));
            queryWrapper.in("sequence_code", tagsList.stream().map(TmCylinderTags::getSequenceCode).collect(Collectors.toList()));
        }
        if (entity instanceof TmCylinderInspection) {
            List<TmCylinderInspection> inspectionList = (List<TmCylinderInspection>) entityList;
            queryWrapper.in("app_id", inspectionList.stream().map(AbstractBaseEntity::getAppId).collect(Collectors.toList()));
            queryWrapper.in("sequence_code", inspectionList.stream().map(TmCylinderInspection::getSequenceCode).collect(Collectors.toList()));
            queryWrapper.in("inspection_date", inspectionList.stream().map(TmCylinderInspection::getInspectionDate).collect(Collectors.toList()));
        }
        if (entity instanceof TmCylinderFillingExamine) {
            List<TmCylinderFillingExamine> fillingExamineList = (List<TmCylinderFillingExamine>) entityList;
            queryWrapper.in("app_id", fillingExamineList.stream().map(AbstractBaseEntity::getAppId).collect(Collectors.toList()));
            queryWrapper.in("sequence_code", fillingExamineList.stream().map(TmCylinderFillingExamine::getSequenceCode).collect(Collectors.toList()));
        }
        if (entity instanceof TmCylinderFillingRecord) {
            List<TmCylinderFillingRecord> fillingRecordList = (List<TmCylinderFillingRecord>) entityList;
            queryWrapper.in("app_id", fillingRecordList.stream().map(AbstractBaseEntity::getAppId).collect(Collectors.toList()));
            queryWrapper.in("sequence_code", fillingRecordList.stream().map(TmCylinderFillingRecord::getSequenceCode).collect(Collectors.toList()));
        }
        if (entity instanceof TmCylinderFilling) {
            List<TmCylinderFilling> fillingBeforeList = (List<TmCylinderFilling>) entityList;
            queryWrapper.in("app_id", fillingBeforeList.stream().map(AbstractBaseEntity::getAppId).collect(Collectors.toList()));
            queryWrapper.in("sequence_code", fillingBeforeList.stream().map(TmCylinderFilling::getSequenceCode).collect(Collectors.toList()));
        }
        if (entity instanceof TmCylinderFillingCheck) {
            List<TmCylinderFillingCheck> fillingBeforeList = (List<TmCylinderFillingCheck>) entityList;
            queryWrapper.in("app_id", fillingBeforeList.stream().map(AbstractBaseEntity::getAppId).collect(Collectors.toList()));
            queryWrapper.in("sequence_code", fillingBeforeList.stream().map(TmCylinderFillingCheck::getSequenceCode).collect(Collectors.toList()));
        }
        if (entity instanceof TmCylinderOffloading) {
            List<TmCylinderOffloading> tmCylinderOffloadingList = (List<TmCylinderOffloading>) entityList;
            queryWrapper.in("credit_code", tmCylinderOffloadingList.stream().map(TmCylinderOffloading::getCreditCode).collect(Collectors.toList()));
            queryWrapper.in("statistics_sync_date", tmCylinderOffloadingList.stream().map(TmCylinderOffloading::getStatisticsSyncDate).collect(Collectors.toList()));
        }
    }
}
