package com.yeejoin.amos.boot.module.tcm.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 警情接警填报记录
 *
 * @author litw
 * @date 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_alert_called")
public class AlertCalled extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 警情状态 (0 未结案 1 结案)
     */
	@TableField("alert_status")
    private Boolean alertStatus;

    /**
     * 警情来源类型
     */
	@TableField("alert_source")
    private String alertSource;

    /**
     * 警情来源类型Code
     */
    @TableField("alert_source_code")
    private String alertSourceCode;

    /**
     * 接警时间
     */
	@TableField("call_time")
    private Date callTime;

    /**
     * 报警人电话
     */
	@TableField("emergency_call")
    private String emergencyCall;

    /**
     * 报警人名称，默认为先生或女士
     */
	@TableField("emergency_person")
    private String emergencyPerson;

    /**
     * 联系人姓名
     */
	@TableField("contact_user")
    private String contactUser;

    /**
     * 联系人电话
     */
	@TableField("contact_phone")
    private String contactPhone;

    /**
     * 设备分类，字典表数据
     */
	@TableField("equipment_classification")
    private String equipmentClassification;

    /**
     * 报警类型
     */
	@TableField("type")
    private String type;

    /**
     * 警情类别
     */
	@TableField("alarm_type")
    private String alarmType;

    /**
     * 通话记录信息id
     */
	@TableField("call_record_id")
    private Integer callRecordId;

    /**
     * 警情阶段
     */
	@TableField("alert_stage")
    private String alertStage;

    /**
     * 父警情id
     */
	@TableField("father_alert")
    private Long fatherAlert;

    /**
     * 设备识别码
     */
	@TableField("device_id")
    private String deviceId;

    /**
     * 注册编码
     */
	@TableField("registration_code")
    private String registrationCode;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 更新时间
     */
	@TableField("update_time")
    private Date updateTime;

    /**
     * 设备分类code
     */
	@TableField("equipment_classification_code")
    private String equipmentClassificationCode;

    /**
     * 报警类型code
     */
	@TableField("type_code")
    private String typeCode;

    /**
     * 警情类别code
     */
	@TableField("alarm_type_code")
    private String alarmTypeCode;

    /**
     * 警情阶段code
     */
	@TableField("alert_stage_code")
    private String alertStageCode;

    /**
     * 组织机构
     */
	@TableField("org_code")
    private String orgCode;

    /**
     * 工单编号
     */
    @TableField("work_order_number")
    private String workOrderNumber;

    @TableField("city")
    @ApiModelProperty(value = "所属地市")
    private String city;

    @TableField("district")
    @ApiModelProperty(value = "所属区县")
    private String district;

    @TableField("region_code")
    @ApiModelProperty(value = "所属区域代码")
    private String regionCode;

    @TableField("forzen_result")
    @ApiModelProperty(value = "冻结原因")
    private String forzenResult;

    @TableField("final_reason")
    @ApiModelProperty(value = "结案说明")
    private String finalReason;

    @TableField(exist=false)
    @ApiModelProperty(value = "使用单位")
    private String useUnit;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "接警时间开始---用于列表过滤")
    @TableField(exist=false)
    private Date callTimeStart ;

    @ApiModelProperty(value = "接警时间结束---用于列表过滤")
    @TableField(exist=false)
    private Date callTimeEnd ;

    @TableField(exist=false)
    @ApiModelProperty(value = "是否处警")
    private Boolean isFatherAlert = false;

    @TableField(exist=false)
    @ApiModelProperty(value = "接警时间str")
    private String callTimeStr;

    /**
     * 响应级别
     */
    @ApiModelProperty(value = "响应级别")
    private String responseLevel;

    @TableField(exist=false)
    @ApiModelProperty(value = "是否辅屏查询")
    private String isAuxiliaryScreen;

    @TableField("equipment_id")
    @ApiModelProperty(value = "设备id")
    private Long equipmentId;


    @TableField(exist=false)
    @ApiModelProperty(value = "现场照片")
    private List<AttachmentDto> images;

}
