package com.yeejoin.amos.boot.module.common.biz.service.impl;

import static org.hamcrest.CoreMatchers.nullValue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.Bean;

import com.itextpdf.text.pdf.PdfStructTreeController.returnType;
import com.yeejoin.amos.boot.module.common.api.dto.DutyFireFightingDto;
import com.yeejoin.amos.boot.module.common.api.dto.DynamicFormInstanceDto;
import com.yeejoin.amos.boot.module.common.api.dto.FireStationDto;
import com.yeejoin.amos.boot.module.common.api.mapper.DutyPersonShiftMapper;
import com.yeejoin.amos.boot.module.common.api.service.IDutyFireFightingService;

@Service
public class DutyFireFightingServiceImpl extends DutyCommonServiceImpl implements IDutyFireFightingService {

	@Autowired
	FireStationServiceImpl fireStationServiceImpl;
	
	@Autowired
	DutyPersonShiftMapper dutyPersonShiftMapper;
	
	@Autowired
	DynamicFormInstanceServiceImpl alertFormValueServiceImpl;
	
	public String getGroupCode() {
		return "dutyFireFighting";
	}
	
	@Override
	@Transactional(rollbackFor = Exception.class)
	public DutyFireFightingDto save(DutyFireFightingDto dto) {
		// 根据微型消防站ID，获取微型消防站名称
		FireStationDto fireStationDtoResult = fireStationServiceImpl
				.queryBySeq(Long.parseLong(dto.getFireFightingId()));
		dto.setFireFighting(fireStationDtoResult.getName());
		Map<String, Object> map = Bean.BeantoMap(dto);
		Long instanceId = excuteDynamicFormInstance(dto.getUserId(), map, this.getGroupCode());
		saveDutyPersonShiftDetail(instanceId, dto.getDutyShift(), dto.getStartTime());
		insertPersonShift(instanceId, dto.getDutyShift());
		return dto;
	}

	@Override
	public DutyFireFightingDto update(Long instanceId, DutyFireFightingDto dto) {
		updateDynamicFormInstance(this.getGroupCode(), instanceId, Bean.BeantoMap(dto));
		insertPersonShift(instanceId, dto.getDutyShift());
		return dto;
	}
	public Object getSchedulingDutyForSpecifyDate(String dutyDay, Long shiftId, String postType) {
		List<Map<String, Object>> equipmentList = dutyPersonShiftMapper.getEquipmentForSpecifyDate(dutyDay,
				this.getGroupCode(), "fireFightingId", "fireFighting", "teamName","result.fireFightingId");
		if(equipmentList==null || equipmentList.size()<1 || equipmentList.get(0)==null) {
			return null;
		}
		List<Object>	detailList = new ArrayList<Object>();
		for (Map<String, Object> map : equipmentList) {
			List<Map<String, Object>>	resultList = new ArrayList<Map<String, Object>>();
			LinkedHashMap<String, Object> titleMap_1 =new LinkedHashMap<String, Object>();
			titleMap_1.put("微型消防站", map.get("fireFighting").toString());
			resultList.add(titleMap_1);
			LinkedHashMap<String, Object> titleMap_2 =new LinkedHashMap<String, Object>();
			titleMap_2.put("单位/部门", map.get("teamName").toString());
			resultList.add(titleMap_2);
			String carId =map.get("fireFightingId").toString();
			Map<String, Object> instanceMap = dutyPersonShiftMapper.getInstanceIdForSpecifyDateAndEquipment(dutyDay,
					this.getGroupCode(), carId);
			if(instanceMap==null) {
				continue;
			}
			String instanceId = instanceMap.get("instanceIds").toString();
			if (StringUtils.isNotBlank(instanceId)) {
				String[] instanceIds = instanceId.split(",");
				
				List<Map<String, Object>>  dutyList = dutyPersonShiftMapper.getDutyForSpecifyDate(dutyDay);
				if(dutyList!=null && dutyList.size()>0) {
					for (Map<String, Object> dutyDetail : dutyList) {
						if(!dutyDetail.containsKey("name")) {
							continue;
						}
						// 获取当前装备ID下的排版数据
						List<Map<String, Object>> specifyDateList = dutyPersonShiftMapper.getPositionStaffDutyForSpecifyDate(dutyDay,
								this.getGroupCode(), instanceIds,dutyDetail.get("name").toString());
						if(specifyDateList==null || specifyDateList.size() < 1 || specifyDateList.get(0)==null) {
							continue;
						}
						LinkedHashMap<String, Object> infoMap_1 =new LinkedHashMap<String, Object>();
						infoMap_1.put(dutyDetail.get("name").toString(), "");
						resultList.add(infoMap_1);
						for (Map<String, Object> specify : specifyDateList) {
							LinkedHashMap<String, Object> infoMap_2 =new LinkedHashMap<String, Object>();
							infoMap_2.put(specify.get("postTypeName").toString(),specify.get("userName").toString());
							resultList.add(infoMap_2);
						}
					}
				}
			}
			detailList.add(resultList);
		}
		return detailList;
	}

	@Override
	public Object getlistDutyPostTypeName(Long userId) {
		List<DynamicFormInstanceDto> dyList = alertFormValueServiceImpl.queryByCalledId(userId);
		Map<String, Object> map = new HashMap<String, Object>();
		if (ObjectUtils.isEmpty(dyList)) {
			return null;
		}
		for (DynamicFormInstanceDto dto : dyList) {
			if ("positionType".equals(dto.getFieldCode())) {
				map.put("postType", dto.getFieldValue());
				map.put("postTypeName", dto.getFieldValueLabel());
				break;
			}
		}
		return map;
	}
}
