package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
* 警情接警记录
*
* @author tb
* @date 2021-06-17
*/
@Data
@ApiModel(value="AlertCalledZhDto", description=" 指挥警情接警记录")
public class AlertCalledZhDto {


    @ApiModelProperty(value = "主键ID")
    protected Long sequenceNbr;

    @ApiModelProperty(value = "警情阶段")
    private String alertStage;


    @ApiModelProperty(value = "接警时间")
    private Date callTime;

    @ApiModelProperty(value = "警情类型")
    private String alertType;

    @ApiModelProperty(value = "报警类型code")
    private String alarmTypeCode;

    @ApiModelProperty(value = "事发单位")
    private String unitInvolved;

    @ApiModelProperty(value = "被困人数")
    private Integer trappedNum;

    @ApiModelProperty(value = "伤亡人数")
    private Integer casualtiesNum;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "救援方格")
    private String rescueGrid;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "标题")
    private String alertTypeName;

    @ApiModelProperty(value = "响应级别字典code 为了过滤用（只有航空器故障有）")
    private String responseLevelCode;

    @ApiModelProperty(value = "警情修改时间")
    private Date updateTime;
}
