package com.yeejoin.amos.latentdanger.common.enums;

import com.yeejoin.amos.boot.biz.common.utils.DynamicEnumUtil;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * 隐患治理方式枚举
 *
 * @author DELL
 */
public enum LatentDangerReformTypeEnum {

    /**
     * 常规整改
     */
    常规整改("常规整改", "1"),
    /**
     * 安措计划
     */
    安措计划("安措计划", "2"),
    /**
     * 延期治理
     */
    延期治理("延期治理", "3");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    /**
     * 枚举缓存
     */
    public static Map<String, LatentDangerReformTypeEnum> enumMap = new HashMap<>();

    public static final String dictCode = "_GOVERNANCE";

    LatentDangerReformTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 根据关键字段获取枚举值  可以在这里做一些修改 来达到动态添加的效果
     *
     * @param code
     */
    public static LatentDangerReformTypeEnum getEnumByCode(String code) {
        // 这里可以做一些修改  比如若从 enumMap 中没有取得 则加载配置动态添加
        return enumMap.get(code);
    }

    public static LatentDangerReformTypeEnum addEnumDynamic(String enumName, String name, String code) {
        LatentDangerReformTypeEnum dangerReformTypeEnum = DynamicEnumUtil.addEnum(LatentDangerReformTypeEnum.class, enumName,
                new Class[]{String.class, String.class}, new Object[]{name, code});
        if (!ValidationUtil.isEmpty(dangerReformTypeEnum)) {
            enumMap.put(code, dangerReformTypeEnum);
        }
        return dangerReformTypeEnum;
    }
}
