package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.core.utils.RestTemplateUtil;
import com.yeejoin.amos.boot.module.jcs.api.service.IFusionService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: xl
 * @Description:
 * @Date: 2021/11/25 10:23
 */
@Service
public class FusionServiceImpl implements IFusionService {

    @Value("${ifc.url}")
    private String voiceURL;

    @Override
    public JSONObject getAllOnlineUser() {
        JSONObject jsonObject = null;
        try {
            jsonObject = RestTemplateUtil.getRestInstance().getForObject(String.format("%s/GetAllOnlineUser", voiceURL), JSONObject.class);
        } catch (RestClientException e) {
            e.printStackTrace();
            throw new BadRequest("访问融合终端失败");
        }
        return jsonObject;
    }

    @Override
    public JSONObject getEmployeeByEID(String employeeID) {
        String url = String.format("%s/api/userManage/getEmployeeByEID?employeeId=%s", voiceURL, employeeID);
        JSONObject jsonObject = null;
        try {
            jsonObject = RestTemplateUtil.getRestInstance().getForObject(url, JSONObject.class);
        } catch (RestClientException e) {
            e.printStackTrace();
            throw new BadRequest("访问融合终端失败");
        }
        return jsonObject;
    }

    @Override
    public Map<String, String> getGISByEmployeeID(String employeeID) {
        MultiValueMap<String, String> requestEntity = new LinkedMultiValueMap<String, String>();
        requestEntity.add("employeeID", employeeID);
        JSONObject jsonObject = null;
        try {
            jsonObject = RestTemplateUtil.getRestInstance().postForObject(String.format("%s/GetGISByEmployeeID", voiceURL), requestEntity, JSONObject.class);
        } catch (RestClientException e) {
            e.printStackTrace();
            throw new BadRequest("访问融合终端失败");
        }
        return getResult(jsonObject);
    }

    @Override
    public Map<String, String> getCallRecordByNumber(String caller, String called) {
        MultiValueMap<String, String> requestEntity = new LinkedMultiValueMap<String, String>();
        requestEntity.add("caller", caller);
        requestEntity.add("called", called);
        JSONObject jsonObject = null;
        try {
            jsonObject = RestTemplateUtil.getRestInstance().postForObject(String.format("%s/GetCallRecordByNumber", voiceURL), requestEntity, JSONObject.class);
        } catch (RestClientException e) {
            e.printStackTrace();
            throw new BadRequest("访问融合终端失败");
        }
        return getResult(jsonObject);
    }

    @Override
    public Map<String, String> getCallRecordByCID(String cid) {
        MultiValueMap<String, String> requestEntity = new LinkedMultiValueMap<String, String>();
        requestEntity.add("CID", cid);
        JSONObject jsonObject = null;
        try {
            jsonObject = RestTemplateUtil.getRestInstance().postForObject(String.format("%s/GetCallRecordByCID", voiceURL), requestEntity, JSONObject.class);
        } catch (RestClientException e) {
            e.printStackTrace();
            throw new BadRequest("访问融合终端失败");
        }
        return getResult(jsonObject);
    }

    public Map<String, String> getResult(JSONObject jsonObject) {
        Map<String, String> map = new HashMap<>();
        if (ValidationUtil.isEmpty(jsonObject)) {
            throw new BadRequest("访问融合终端失败");
        }
        if (jsonObject.get("data") instanceof Map) {
            JSONObject data = jsonObject.getJSONObject("data");
            map = (Map) data;
        } else {
            JSONArray data = jsonObject.getJSONArray("data");
            if (!ValidationUtil.isEmpty(data)) {
                map = (Map) data.get(0);
            }
        }
        return map;
    }
}
