package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.common.restful.utils.ResponseHelper;
import com.yeejoin.amos.api.common.restful.utils.ResponseModel;

import com.yeejoin.amos.api.openapi.face.orm.entity.TaAccessConfig;
import com.yeejoin.amos.api.openapi.face.orm.entity.TaLicenseBaseInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.TaLicenseDetailInfo;
import com.yeejoin.amos.api.openapi.face.service.TaAccessConfigServiceImpl;
import com.yeejoin.amos.api.openapi.face.service.TaLicenseBaseInfoServiceImpl;
import com.yeejoin.amos.api.openapi.face.service.TaLicenseDetailInfoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.List;

@RestController
@RequestMapping(value = "/license")
@Api(tags = "许可数据对接")
public class LicenseController {

	@Autowired
	private TaAccessConfigServiceImpl taAccessConfigService;

	@Autowired
	private TaLicenseDetailInfoServiceImpl taLicenseDetailInfoService;

	@Autowired
	private TaLicenseBaseInfoServiceImpl taLicenseBaseInfoService;

//    /**
//     * 新增许可信息-接入配置表
//     * @return
//     */
//    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
//    @RequestMapping(value = "/saveAccessConfig", method = RequestMethod.POST)
//    @ApiOperation(httpMethod = "POST", value = "新增许可信息-接入配置表", notes = "新增许可信息-接入配置表")
//    @RestEventTrigger(value = "openapiLogEventHandler")
//    public ResponseModel<String> saveTaAccessConfig (@RequestBody List<TaAccessConfig> produceInfo) throws Exception
//    {
//        return ResponseHelper.buildResponse(taAccessConfigService.saveAccessConfig(produceInfo));
//    }

	/**
	 * 新增许可信息-许可基本信息表
	 * 
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@RequestMapping(value = "/saveLinceseBaseInfo", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "新增许可信息-许可基本信息表", notes = "新增许可信息-许可基本信息表")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> saveTaLicenseBaseInfo() throws Exception {
		taLicenseBaseInfoService.syncLicenseData();
		return ResponseHelper.buildResponse("");
	}

	/**
	 * 新增许可信息-许可详细信息表
	 * 
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@RequestMapping(value = "/saveLinceseDetailInfo", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "新增许可信息-许可详细信息表", notes = "新增许可信息-许可详细信息表")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> saveTaLicenseDetailInfo()
			throws Exception {
		taLicenseDetailInfoService.syncLicenseData();
		return ResponseHelper.buildResponse("");
	}
	
	/**
	 * 新增许可信息-许可详细信息表
	 * 
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@RequestMapping(value = "/refreshConfig", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "更新配置", notes = "更新配置")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> refreshConfig()
			throws Exception {
		taAccessConfigService.refreshConfig();
		return ResponseHelper.buildResponse("");
	}

}
