package com.yeejoin.amos.boot.module.jg.biz.refresh;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.module.common.api.dto.ITechParamDefine;
import com.yeejoin.amos.boot.module.common.api.dto.TechParamItem;
import com.yeejoin.amos.boot.module.common.api.entity.ESEquipmentInfo;
import com.yeejoin.amos.boot.module.common.biz.utils.RefreshDataUtils;
import com.yeejoin.amos.boot.module.common.biz.utils.TechParamUtil;
import com.yeejoin.amos.boot.module.jg.biz.edit.backup.TechParamsBackupService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgInspectionDetectionInfo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service
@RequiredArgsConstructor
@Slf4j
public class StatisticsDataUpdateService {

    private final TechParamsBackupService techParamsBackupService;

    public static final String USE_DATE_KEY = "USE_DATE";


    public List<ESEquipmentInfo.TechParam> getTechParams(String equList, String record) {
        List<ESEquipmentInfo.TechParam> techParams = new ArrayList<>();
        try {
            Object params = techParamsBackupService.getTechParams(equList, record);
            // 类型转换，否则类型处理错误
            Class<? extends ITechParamDefine> clazz = TechParamUtil.getParamClazz(equList);
            ITechParamDefine paramInstance = clazz.newInstance();
            BeanUtil.copyProperties(params, paramInstance);

            Map<String, Object> paramsMap = BeanUtil.beanToMap(paramInstance);
            List<TechParamItem> techParamItems = TechParamUtil.getParamMetaList(equList);
            techParamItems.forEach(techParamItem -> {
                ESEquipmentInfo.TechParam techParam = new ESEquipmentInfo.TechParam(techParamItem, paramsMap.get(techParamItem.getParamKey()));
                techParams.add(techParam);
            });
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return techParams;
    }


    public static void formatUseDate(Map<String, Object> detail) {
        if (detail.containsKey(USE_DATE_KEY) && detail.get(USE_DATE_KEY) != null) {
            if (detail.get(USE_DATE_KEY).toString().isEmpty() || detail.get(USE_DATE_KEY).toString().equals("null")) {
                detail.put(USE_DATE_KEY, null);
            } else {
                String useDateStr = "";
                try {
                    useDateStr = detail.get(USE_DATE_KEY).toString();
                    detail.put(USE_DATE_KEY, DateUtil.parse(useDateStr));
                } catch (Exception e) {
                    log.error("非法的USE_DATE格式：{}", useDateStr);
                    detail.put(USE_DATE_KEY, null);
                }
            }
        }
    }


    public static void formatInspectDate(ESEquipmentInfo esEquipmentInfo, IdxBizJgInspectionDetectionInfo inspectionDetectionInfo, String record) {
        try {
            esEquipmentInfo.setINSPECT_DATE(inspectionDetectionInfo.getSequenceNbr() != null ? inspectionDetectionInfo.getInspectDate() != null ? inspectionDetectionInfo.getInspectDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate() : null : null);
        } catch (Exception e) {
            log.error("INSPECT_DATE时区转换失败：{}", record, e);
        }
        try {
            esEquipmentInfo.setNEXT_INSPECT_DATE(inspectionDetectionInfo.getSequenceNbr() != null ? inspectionDetectionInfo.getNextInspectDate() != null ? inspectionDetectionInfo.getNextInspectDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate() : null : null);
        } catch (Exception e) {
            log.error("NEXT_INSPECT_DATE时区转换失败：{}", record, e);
        }
    }

}
