package com.yeejoin.amos.boot.module.tcm.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author litw
 * @date 2021-09-28.
 */
@Data
public class AlertPaperInfoDto {

    @ApiModelProperty(value = "警情id")
    private Long alertId;

    @ApiModelProperty(value = "所属区域代码")
    private String regionCode;

    @ApiModelProperty(value = "电梯应急救援识别码")
    private Integer rescueCode;

    @ApiModelProperty(value = "警情类别code")
    private String alarmTypeCode;

    @ApiModelProperty(value = "警情类别")
    private String alarmType;

    @ApiModelProperty(value = "所属区域")
    private String area;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "报警时间")
    private Date callTime;

    @ApiModelProperty(value = "救援倒计时")
    private String rescueTime;

    @ApiModelProperty(value = "被困人数")
    private String trappedNum;

    @ApiModelProperty(value = "死亡人数")
    private String dieNum;

    @ApiModelProperty(value = "受伤人数")
    private String injuredNum;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "停留时间")
    private String stopTime;

    @ApiModelProperty(value = "状态信息")
    private String alertStatus;

    @ApiModelProperty(value = "电梯id")
    private String elevatorId;

    @ApiModelProperty(value = "电梯设备编码")
    private String elevatorCode;

    @ApiModelProperty(value = "警情结束时间")
    private Date finishTime;

}
