package com.yeejoin.amos.boot.module.common.biz.refresh.adapter;

import com.yeejoin.amos.boot.module.common.biz.event.CommonPublisher;
import com.yeejoin.amos.boot.module.common.biz.refresh.DataRefreshEvent;
import lombok.RequiredArgsConstructor;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Component
@RequiredArgsConstructor
public class DataRefreshEventBuilderService {

    private final CommonPublisher publisher;

    @Transactional(rollbackFor = Exception.class)
    public void processMessage(String topic, List<String> records) {
        String[] topicCxt = topic.split(MqttTopic.TOPIC_LEVEL_SEPARATOR);
        if (topicCxt.length == 4) {
            String dataType = topicCxt[2];
            String operation = topicCxt[3];
            DataRefreshEvent dataRefreshEvent = new DataRefreshEvent(this, records, dataType, DataRefreshEvent.Operation.valueOf(operation));
            publisher.publish(dataRefreshEvent);
        }
    }
}
