package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 工程装置-检验检测信息表
 *
 * @author system_generator
 * @date 2024-12-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "IdxBizJgProjectInspectionDto", description = "工程装置-检验检测信息表")
public class IdxBizJgProjectInspectionDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    private String record;

    private Date recDate;

    private String recUserId;

    private String instanceId;

    private String status;

    @ApiModelProperty(value = "检验类型")
    private String inspectType;

    @ApiModelProperty(value = "检验机构名称")
    private String inspectOrgName;

    @ApiModelProperty(value = "检验报告")
    private String inspectReport;

    @ApiModelProperty(value = "检验人员")
    private String inspectStaff;

    @ApiModelProperty(value = "检验日期")
    private Date inspectDate;

    @ApiModelProperty(value = "检验结论")
    private String inspectConclusion;

    @ApiModelProperty(value = "安全状况等级")
    private String safetyLevel;

    @ApiModelProperty(value = "检验问题备注")
    private String problemRemark;

    @ApiModelProperty(value = "下次检验日期")
    private Date nextInspectDate;

    @ApiModelProperty(value = "工程装置唯一标识")
    private String sequenceCode;

    @ApiModelProperty(value = "检验机构统一信用代码")
    private String inspectOrgCode;

    @ApiModelProperty(value = "检验报告编号")
    private String inspectReportNo;

    @ApiModelProperty(value = "检验人员主键多个逗号分割")
    private String inspectStaffCode;

    @ApiModelProperty(value = "关联设备ids")
    private String equipRecord;

    @ApiModelProperty(value = "检验申请单编号")
    private String inspectApplyNo;

    @ApiModelProperty(value = "工程装置ID")
    private String projectContraptionId;

}
