package com.yeejoin.amos.api.openapi.feign;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.api.openapi.dto.XiAnEquipInfoExcelDto;
import com.yeejoin.amos.api.openapi.face.model.ElevatorModel;
import com.yeejoin.amos.boot.biz.common.feign.FeignConfiguration;
import com.yeejoin.amos.boot.module.cylinder.api.dto.PageParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Date;
import java.util.List;
import java.util.Map;

@FeignClient(name = "TZS-JG", path = "/jg", configuration = {FeignConfiguration.class})
public interface TzsJgServiceFeignClient {

    /**
     * 根据企业统一信用代码询许可信息
     *
     * @param unitCode 企业唯一编码
     * @return
     */
    @RequestMapping(value = "/baseEnterprise/getUnitLicenceMessage", method = RequestMethod.GET)
    ResponseModel<Object> getLicenceByUnitCode(@RequestParam String unitCode);


    /**
     * 字段列表查询
     *
     * @param dictCode 字段类型
     * @return 列表
     */
    @RequestMapping(value = "/getDataDictionary/{dictCode}", method = RequestMethod.GET)
    ResponseModel<Object> getDataDictionary(@PathVariable String dictCode);

    /**
     * 根据时间范围查询
     *
     * @param equCode   设备代码
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return 电梯数据
     */
    @RequestMapping(value = "/equipment-register/getElevatorInfo", method = RequestMethod.GET)
    IPage<ElevatorModel> getElevatorInfo(@RequestParam("equCode") String equCode,
                                         @RequestParam("startTime") Date startTime,
                                         @RequestParam("startTime") Date endTime,
                                         PageParam pageParam);

    /**
     * 根据时间范围查询液化石油气瓶档案
     *
     * @param equCode   设备代码
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return 电梯数据
     */
    @RequestMapping(value = "/equipment-register/getCylinderInfo", method = RequestMethod.GET)
    IPage<ElevatorModel> getCylinderInfo(@RequestParam("equCode") String equCode,
                                         @RequestParam("startTime") Date startTime,
                                         @RequestParam("startTime") Date endTime,
                                         PageParam pageParam);

    /**
     * 查询气站信息
     *
     * @return
     */
    @RequestMapping(value = "/equipment-register/getCylinderStationInfo", method = RequestMethod.GET)
    List<Map<String, Object>> getCylinderStationInfo();

    @RequestMapping(value = "/equipment-register/getVehicleCylinderInfo", method = RequestMethod.GET)
    List<Map<String, Object>> getVehicleCylinderInfo(String useCode);

    /**
     * 批量保存西安上传的设备数据
     *
     * @param equipInfoExcelDtos
     * @return
     */
    @RequestMapping(value = "/xi-an/saveEquipmentData", method = RequestMethod.POST)
    Object saveEquipmentData(@RequestBody List<XiAnEquipInfoExcelDto> equipInfoExcelDtos);

    /**
     * 设备代码唯一性检查
     *
     * @param equCode
     * @return
     */
    @RequestMapping(value = "/common/checkEquCodeUniqueness", method = RequestMethod.GET)
    Boolean selectByEquCodeAndClaimStatus(@RequestParam("equCode") String equCode);


    /**
     * 车用气瓶业务里面的 出厂编号/产品编码 校验唯一性（产品编号在车用气瓶范围内全局唯一）
     *
     * @param factoryNum
     * @return
     */
    @RequestMapping(value = "/common/checkFactoryNumUniquenessForVehicleCylinder", method = RequestMethod.GET)
    Integer checkFactoryNumUniquenessForVehicleCylinder(@RequestParam("factoryNum") String factoryNum);
}
