package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.CompanyEquipCountDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgEquipTransferDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgEquipTransfer;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo.EquipTransferVo;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 设备移交 Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-20
 */
public interface JgEquipTransferMapper extends CustomBaseMapper<JgEquipTransfer> {
    Page<JgEquipTransferDto> queryForPage(Page<JgEquipTransferDto> page,
                                          @Param("sort") SortVo sortMap,
                                          @Param("param") JgEquipTransferDto model,
                                          @Param("currentUserId") String currentUserId);

    List<EquipTransferVo> queryEquipTransferInIds(@Param("ids") List<String> ids);

    @MapKey("sequenceNbr")
    List<Map<String, Object>> queryEquipInformation(Long sequenceNbr);

    List<CompanyEquipCountDto> queryForFlowingEquipList();
}
