package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationEquip;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationEquipMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationEquipModel;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionApplicationEquipService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Collections;
import java.util.List;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Service
public class JyjcInspectionApplicationEquipServiceImpl extends BaseService<JyjcInspectionApplicationEquipModel,JyjcInspectionApplicationEquip,JyjcInspectionApplicationEquipMapper> implements IJyjcInspectionApplicationEquipService {
    /**
     * 分页查询
     */
    public Page<JyjcInspectionApplicationEquipModel> queryForJyjcInspectionApplicationEquipPage(Page<JyjcInspectionApplicationEquipModel> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<JyjcInspectionApplicationEquipModel> queryForJyjcInspectionApplicationEquipList()   {
        return this.queryForList("" , false);
    }

    public List listApplicationEquipByApplicationSeq(Long applicationSeq)   {
        // this.queryForList 尽量不要重载方法
        List<JyjcInspectionApplicationEquip> entitys = this.lambdaQuery().eq(JyjcInspectionApplicationEquip::getApplicationSeq, applicationSeq).list();
        if (ValidationUtil.isEmpty(entitys)) {
            return Collections.EMPTY_LIST;
        }
        return Bean.toModels(entitys, JyjcInspectionApplicationEquipModel.class);
    }
}