package com.yeejoin.amos.supervision.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PlanCheckLevelEnum {
    DRAFT("单位级",0),
    EXAMINE_ONE("公司级",1);

    /**
     * 名称
     */
    private String name;

    /**
     * 值
     */
    private int value;

    private PlanCheckLevelEnum(String name, int value) {
        this.name = name;
        this.value = value;
    }


    public static String getName(int value) {
        for (PlanCheckLevelEnum c : PlanCheckLevelEnum.values()) {
            if (c.getValue() == value) {
                return c.name;
            }
        }
        return null;
    }

    public static int getValue(String name) {
        for (PlanCheckLevelEnum c : PlanCheckLevelEnum.values()) {
            if (c.getName().equals(name)) {
                return c.value;
            }
        }
        return -1;
    }


    public static PlanCheckLevelEnum getEnum(int value) {
        for (PlanCheckLevelEnum c : PlanCheckLevelEnum.values()) {
            if (c.getValue() == value) {
                return c;
            }
        }
        return null;
    }


    public static PlanCheckLevelEnum getEnum(String name) {
        for (PlanCheckLevelEnum c : PlanCheckLevelEnum.values()) {
            if (c.getName().equals(name)) {
                return c;
            }
        }
        return null;
    }

    public static List<Map<String,String>> getEnumList() {
        List<Map<String,String>> nameList = new ArrayList<>();
        for (PlanCheckLevelEnum c: PlanCheckLevelEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("name", c.getName());
            map.put("value", c.getValue() +"");
            nameList.add(map);
        }
        return nameList;
    }

    public static List<String> getEnumNameList() {
        List<String> nameList = new ArrayList<String>();
        for (PlanCheckLevelEnum c: PlanCheckLevelEnum.values()) {
            nameList.add(c.getName());
        }
        return nameList;
    }

    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }


    public int getValue() {
        return value;
    }


    public void setValue(int value) {
        this.value = value;
    }
}
