package com.yeejoin.amos.supervision.core.framework;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.yeejoin.amos.supervision.business.util.CommonResponse;
import com.yeejoin.amos.supervision.business.util.CommonResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ResponseBody;

import com.yeejoin.amos.supervision.exception.PermissionException;
import com.yeejoin.amos.supervision.exception.YeeException;


@ControllerAdvice
public class ExceptionHandler {
	
	private static final Logger logger = LoggerFactory.getLogger(ExceptionHandler.class);
	
	@org.springframework.web.bind.annotation.ExceptionHandler(PermissionException.class)
    @ResponseBody
    public CommonResponse handlePermissionException(HttpServletRequest request, HttpServletResponse resp, PermissionException ex) {
		resp.setStatus(HttpStatus.UNAUTHORIZED.value());
        return CommonResponseUtil.failure(ex.getMessage());
    }
	
	@org.springframework.web.bind.annotation.ExceptionHandler(YeeException.class)
    @ResponseBody
    public CommonResponse handleYeeException(HttpServletRequest request, YeeException ex) {
        return CommonResponseUtil.failure(ex.getMessage());
    }
	
    @org.springframework.web.bind.annotation.ExceptionHandler(Exception.class)
    @ResponseBody
    public CommonResponse handleException(HttpServletRequest request, Exception ex) {
    	return CommonResponseUtil.failure(ex.getMessage());
    }
}
