package com.yeejoin.amos.boot.module.common.api.dto;

import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* 机构/部门/人员表
*
* @author tb
* @date 2021-06-18
*/
@Data
@Accessors(chain = true)
@TableName("cb_org_usr")
@ApiModel(value="OrgUsrVo", description="机构/部门/人员表")
public class OrgUsrFormDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "单位id")
    private Long id;
    @ApiModelProperty(value = "单位id")
    protected Long sequenceNbr;

    @ApiModelProperty(value = "单位名称")
    private String currentUnit;

    @ApiModelProperty(value = "归属机构/部门")
    private String parentId;
    
    @ApiModelProperty(value = "机构/部门名称")
    private String bizOrgName;

    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "amos中公司/部门ID")
    private String amosOrgId;

    @ApiModelProperty(value = "amos中公司/部门编码")
    private String amosOrgCode;

    @ApiModelProperty(value = "机构类型`")
    private String bizOrgType;

    @ApiModelProperty(value = "所属建筑名称")
    private String buildName;

    @ApiModelProperty(value = "所属建筑ID")
    private String buildId;

    private Integer personNum;

    @ApiModelProperty(value = "动态表单值")
    private List<FormValue> dynamicFormAlert;

    @ApiModelProperty(value = "单位人员信息值")
    private List<OrgPersonFormDto> children;

    public List<FormValue> getDynamicFormAlert() {
		return dynamicFormAlert;
	}


    @ApiModelProperty(value = "转换动态表单")
    private Map<String,Object> map=new HashMap<>();;

    @ApiModelProperty(value = "省市区code,用逗号分隔")
    private String pczCode;

    @ApiModelProperty(value = "省市区名称,用逗号分隔")
    private String pczName;

    @ApiModelProperty(value = "唯一编号")
    private String code;
    @ApiModelProperty(value = "归属机构/部门")
    private String parentName;


    @ApiModelProperty(value = "消防管理人")
    private String xfgl;
    @ApiModelProperty(value = "单位负责人")
    private String dwfz;
    @ApiModelProperty(value = "消防安全负责人")
    private String xfaq;

	public void setDynamicFormAlert(List<FormValue> dynamicFormAlert) {
		  if(dynamicFormAlert!=null) {
			  dynamicFormAlert.forEach(formValue->{
				    if("select".equals(formValue.getType())){
                        this.map.put(formValue.getKey(), formValue.getValueName());

                    }else{
                        this.map.put(formValue.getKey(), formValue.getValue());

                    }

				});
		  }
		
		  this.dynamicFormAlert=dynamicFormAlert;
		
	}




	public OrgUsrFormDto() {
    }
}
