package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
* 特种设备基本信息-注册登记信息 Vo
*
* @author duanwei
* @date 2022-07-20
*/
@EqualsAndHashCode(callSuper = true)
@Data
public class RegistrationInfoModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;

    private List useRegistCertificate;


            @ApiModelProperty(value = "设备唯一标识码")
    /**
    * 设备唯一标识码
    */
    private String sequenceCode;
            @ApiModelProperty(value = "监管系统唯一编码")
    /**
    * 监管系统唯一编码
    */
    private String superviseCode;

    /**
     * 登记机关组织机构代码
     */
    @ApiModelProperty(value = "登记机关组织机构代码")
    private String organizationCode;

            @ApiModelProperty(value = "登记机关名称")
    /**
    * 登记机关名称
    */
    private String organizationName;
            @ApiModelProperty(value = "使用登记证编号")
    /**
    * 使用登记证编号
    */
    private String useOrgCode;
            @ApiModelProperty(value = "注册状态(已注册 未注册)")
    /**
    * 注册状态(已注册未注册)
    */
    private String registerState;
            @ApiModelProperty(value = "使用登记ID")
    /**
    * 使用登记ID
    */
    private String useOrgId;
            @ApiModelProperty(value = "设备代码")
    /**
    * 设备代码
    */
    private String equCode;
            @ApiModelProperty(value = "设备种类")
    /**
    * 设备种类
    */
    private String equList;
            @ApiModelProperty(value = "设备类别")
    /**
    * 设备类别
    */
    private String equCategory;
            @ApiModelProperty(value = "设备品种")
    /**
    * 设备品种
    */
    private String equDefine;
            @ApiModelProperty(value = "产品名称")
    /**
    * 产品名称
    */
    private String productName;
            @ApiModelProperty(value = "品牌名称")
    /**
    * 品牌名称
    */
    private String brandName;
            @ApiModelProperty(value = "设备型号")
    /**
    * 设备型号
    */
    private String equType;
            @ApiModelProperty(value = "设备总价值（万元）")
    /**
    * 设备总价值（万元）
    */
    private Double equPrice;



}
