package com.yeejoin.equipmanage.common.datasync.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @ProjectName: YeeFireDataProcessRoot
 * @Package: com.yeejoin.equipmanage.common.datasync.entity
 * @ClassName: FireEquipMeasurement
 * @Author: Jianqiang Gao
 * @Description: 设备量测信息
 * @Date: 2021/3/24 11:10
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@TableName("ast_firevehiclemeasurement")
@ApiModel(value = "FireVehicleMeasurement对象", description = "消防车辆量测信息数据")
public class FireVehicleMeasurement implements Serializable {

    private static final long serialVersionUID = -3248701104697817215L;

    @ApiModelProperty(value = "ID")
    @TableId("id")
    private String id;

    @ApiModelProperty(value = "点位mRID")
    @TableField("mrid")
    private String mRid;

    @ApiModelProperty(value = "消防车辆id")
    @TableField("firevehicleid")
    private String fireVehicleId;

    @ApiModelProperty(value = "量测数据类型")
    @TableField("type")
    private String type;

    @ApiModelProperty(value = "字段名（英文）")
    @TableField("fieldname")
    private String fieldName;

    @ApiModelProperty(value = "中文名")
    @TableField("fieldlabel")
    private String fieldLabel;

    @ApiModelProperty(value = "属性值")
    @TableField("value")
    private String value;

    @ApiModelProperty(value = "属性下限")
    @TableField("valuemin")
    private String valueMin;

    @ApiModelProperty(value = "属性上限")
    @TableField("valuemax")
    private String valueMax;

    @ApiModelProperty(value = "数据类型")
    @TableField("datatype")
    private String dataType;

    @ApiModelProperty(value = "计量单位")
    @TableField("measureunit")
    private String measureUnit;

    @ApiModelProperty(value = "排序")
    @TableField("sort")
    private Integer sort;

    @ApiModelProperty(value = "创建时间")
    @TableField("createdate")
    private Date createDate;

    @ApiModelProperty(value = "修改时间")
    @TableField("updatedate")
    private Date updateDate;

}