package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.EquipmentQrcode;
import com.yeejoin.equipmanage.common.utils.NameUtils;
import com.yeejoin.equipmanage.service.IEquipmentQrcodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@RestController
@Api(tags = "车辆二维码Api")
@RequestMapping(value = "/equipment-qrcode", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class EquipmentQrcodeController {

	@Autowired
	IEquipmentQrcodeService iEquipmentQrcodeService;

	/**
	 * 新增
	 * 
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public boolean saveEquipmentQrcode(HttpServletRequest request, @RequestBody EquipmentQrcode equipmentQrcode) {
		return iEquipmentQrcodeService.save(equipmentQrcode);
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iEquipmentQrcodeService.removeById(id);
	}

	/**
	 * 修改
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
	public boolean updateByIdEquipmentQrcode(HttpServletRequest request, @RequestBody EquipmentQrcode equipmentQrcode) {
		return iEquipmentQrcodeService.updateById(equipmentQrcode);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public EquipmentQrcode selectById(HttpServletRequest request, @PathVariable Long id) {
		return iEquipmentQrcodeService.getById(id);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<EquipmentQrcode> listPage(String pageNum, String pageSize, EquipmentQrcode equipmentQrcode) {

		Page<EquipmentQrcode> pageBean;
		QueryWrapper<EquipmentQrcode> equipmentQrcodeQueryWrapper = new QueryWrapper<>();
		Class<? extends EquipmentQrcode> aClass = equipmentQrcode.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(equipmentQrcode);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(equipmentQrcode);
						equipmentQrcodeQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(equipmentQrcode);
						equipmentQrcodeQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(equipmentQrcode);
						equipmentQrcodeQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(equipmentQrcode);
						equipmentQrcodeQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<EquipmentQrcode> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iEquipmentQrcodeService.page(pageBean, equipmentQrcodeQueryWrapper);
		return page;
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/page", method = RequestMethod.GET)
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<EquipmentQrcode> page(String pageNum, String pageSize, EquipmentQrcode equipmentQrcode) {

		Page<EquipmentQrcode> pageBean;
		IPage<EquipmentQrcode> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iEquipmentQrcodeService.page(pageBean, equipmentQrcode);
		return page;
	}
}
