package com.yeejoin.amos.fas.business.scheduled;

import com.yeejoin.amos.fas.business.service.intfc.IContingencyInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.LinkedList;
import java.util.Map;
@Component
public class FireScheduled {

	private static final Logger log = LoggerFactory.getLogger(FireScheduled.class);
	
	private static LinkedList<Map<String, String>> fireQueue = new LinkedList<>();
    @Autowired
    IContingencyInstance iContingencyInstance;
	@Scheduled(cron = "*/2 * * * * ?")
	public void runFireQueue() throws Exception {
		if (fireQueue.size() == 0)
			return;

		Map<String, String> map = fireQueue.getFirst();
		String batchNo = map.get("batchNo");
		String stepCode = map.get("stepCode");
		String buttonCode = map.get("buttonCode");
		String confirm = map.get("confirm");
		String contingencyPlanId = map.get("contingencyPlanId");
		String stepState = map.get("stepState");
//		String token = map.get("token");
//		String product = map.get("product");
		try {
			log.info("fireQueue-size:" + fireQueue.size());
			log.info("stepCode:" + map.get("stepCode"));
			log.info("buttonCode:" + map.get("buttonCode"));
			log.info("confirm:" + map.get("confirm"));
			log.info("stepState:" + map.get("stepState"));
//			RequestContext.setToken(token);
//			RequestContext.setProduct(product);
			iContingencyInstance.setButtonExecuted(batchNo, contingencyPlanId, buttonCode, confirm);
			iContingencyInstance.fire(batchNo, stepCode, contingencyPlanId, buttonCode, confirm, stepState);
		} catch (Exception e) {
			throw e;
		} finally {
			fireQueue.removeFirst();
		}
	}
	public static LinkedList<Map<String, String>> getFireQueue() {
		return fireQueue;
	}
	public static void setFireQueue(LinkedList<Map<String, String>> fireQueue) {
		FireScheduled.fireQueue = fireQueue;
	}

}
