package com.yeejoin.amos.boot.module.jcs.biz.controller;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.yeejoin.amos.boot.module.common.api.enums.ExceptionEnum;
import org.apache.commons.jexl2.UnifiedJEXL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.toolkit.Sequence;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.dto.ExcelDto;
import com.yeejoin.amos.boot.module.jcs.api.enums.ExcelEnums;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.DataSourcesImpl;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.ExcelServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 导出导入
 *
 * @author system_generator
 * @date 2021-06-29
 */
@RestController
@Api(tags = "导出")
@RequestMapping(value = "/excel")
public class ExcelController extends BaseController {

	@Autowired
	ExcelServiceImpl excelService;

	@Autowired
	DataSourcesImpl dataSources;

	@Autowired
	RedisUtils redisUtils;

	@Autowired
	Sequence sequence;


    @Value("${logic}")
    private Boolean logic ;


	private static String JCDWRY = "JCDWRY";
	private static String DLDWRY = "DLDWRY";
	//同步机场单位
    private static String JCDWRYTP = "JCDWRYTP";

	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "获取上传excle文件是否成功")
	@GetMapping("/get/template/isSuccess/{key}")
	public ResponseModel<Object> getTemplateIsSuccess(HttpServletResponse response,
			@PathVariable(value = "key") String key) {
		if (redisUtils.hasKey(key)) {
			Object obj = redisUtils.get(key);
			return ResponseHelper.buildResponse(obj);
		}
		return ResponseHelper.buildResponse(null);
	}

	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "下载模板")
	@GetMapping("/download/template/{type}")
	public void downloadTemplate(HttpServletResponse response, @PathVariable(value = "type") String type) {
		try {
			if(type.equals(JCDWRY) && logic != null&& !logic){
				type = DLDWRY;
			}
			ExcelEnums excelEnums = ExcelEnums.getByKey(type);
			ExcelDto excelDto = new ExcelDto(excelEnums.getFileName(), excelEnums.getSheetName(),
					excelEnums.getClassUrl(), excelEnums.getType());
			excelService.templateExport(response, excelDto);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BadRequest(ExceptionEnum.PARAMETER_TYPE_ERR.getEmsg());
		}
	}

	/**
	 * * @param Map par 可以传递过滤条件，传入具体实现类中
	 *
	 * @return
	 *
	 *         <PRE>
	 * author tw
	 * date 2021/9/13
	 *         </PRE>
	 */
	@TycloudOperation(needAuth = false,ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "导出公用类")
	@GetMapping("/export/{type}")
	public void getFireStationFile(HttpServletResponse response, @PathVariable(value = "type") String type,
			@RequestParam Map<String,Object> par) {
		try {
			if(type.equals(JCDWRY) && logic != null &&!logic){
				type = DLDWRY;
			}
			ExcelEnums excelEnums = ExcelEnums.getByKey(type);
			ExcelDto excelDto = new ExcelDto(excelEnums.getFileName(), excelEnums.getSheetName(),
					excelEnums.getClassUrl(), excelEnums.getType());
			excelService.commonExport(response, excelDto, par);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BadRequest(ExceptionEnum.PARAMETER_TYPE_ERR.getEmsg());
		}
	}

	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "导入公用")
	@PostMapping("/upload/{type}")
	public ResponseModel<Object> upload(@RequestPart("file") MultipartFile multipartFile,
			@PathVariable(value = "type") String type,HttpServletRequest equest) {
		try {
			long uuid = sequence.nextId();
			String uuidString = Long.toString(uuid);
			redisUtils.set(uuidString, 0);
			if(type.equals(JCDWRY) && logic !=null && !logic){
				type = DLDWRY;
			}
			ExcelEnums excelEnums = ExcelEnums.getByKey(type);
			ExcelDto excelDto = new ExcelDto(excelEnums.getFileName(), excelEnums.getSheetName(),
					excelEnums.getClassUrl(), excelEnums.getType());
			excelService.commonUpload(multipartFile, excelDto, uuidString,equest);
			return ResponseHelper.buildResponse(uuidString);
		} catch (RuntimeException e) {
			e.printStackTrace();
			throw new BadRequest(e.getMessage());
		} catch (Exception e) {
			throw new BadRequest("文件格式不正确或excel 模板不匹配！");
		}

	}

	/**
	 * 导出值班模板
	 *
	 * @param response
	 * @param beginDate 值班开始日期
	 * @param endDate   值班结束日期
	 * @param excelDto  导出类型参数
	 * @param ids       部门或队伍的id列表，逗号分隔
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "导出值班模板", notes = "导出值班模板")
	@PostMapping (value = "/duty_template")
	public void dutyCarTemplate(HttpServletResponse response, @RequestParam("beginDate") String beginDate,
			@RequestParam("endDate") String endDate, ExcelDto excelDto, @RequestBody String ids) {
		try {
			if(org.apache.commons.lang3.StringUtils.isNotEmpty(ids)) {
				ids = ids.substring(1,ids.length()-1);
				excelService.dutyTemplateExport(response, beginDate, endDate, excelDto, ids);
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new BadRequest(ExceptionEnum.PARAMETER_TYPE_ERR.getEmsg());
		}
	}

	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "导出值班信息", notes = "导出值班模板")
	@GetMapping(value = "/duty_info")
	public void dutyCarDuty(HttpServletResponse response, @RequestParam("beginDate") String beginDate,
			@RequestParam("endDate") String endDate, ExcelDto excelDto) {
		try {
			excelService.dutyInfoExport(response, beginDate, endDate, excelDto);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BadRequest(ExceptionEnum.PARAMETER_TYPE_ERR.getEmsg());
		}
	}

	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "导出公用类带过滤参数")
	@PostMapping("/exportByParams/{type}")
	public void getFireStationFileByParams(HttpServletResponse response, @PathVariable(value = "type") String type,
			@RequestParam(value = "params") String params) {
		try {
			ExcelEnums excelEnums = ExcelEnums.getByKey(type);
			ExcelDto excelDto = new ExcelDto(excelEnums.getFileName(), excelEnums.getSheetName(),
					excelEnums.getClassUrl(), excelEnums.getType());
			excelService.exportByParams(response, excelDto, params);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BadRequest(ExceptionEnum.PARAMETER_TYPE_ERR.getEmsg());
		}
	}

	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "导出给提供设备接口")
	@GetMapping(value = "/exportForEquipment")
	public ResponseModel<String[]> getFireStationFileByParams(String type, String method) {
		try {
			return ResponseHelper.buildResponse(dataSources.selectList(type, method));
		} catch (Exception e) {
			e.printStackTrace();
			throw new BadRequest(ExceptionEnum.PARAMETER_TYPE_ERR.getEmsg());
		}
	}

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取导入接口")
    @GetMapping(value = "/getexport/{key}")
    public ResponseModel<Object> getexport(@PathVariable(value = "key")String key) {
       Object ob= redisUtils.get(key);
      return ResponseHelper.buildResponse(ob);
    }


    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导入公用")
    @PostMapping("/uploadNew")
    public ResponseModel<Object> uploadNew(@RequestPart("file") MultipartFile multipartFile,
                                        HttpServletRequest equest) {
        try {
            ExcelEnums excelEnums = ExcelEnums.getByKey(JCDWRYTP);
            ExcelDto excelDto = new ExcelDto(excelEnums.getFileName(), excelEnums.getSheetName(),
                    excelEnums.getClassUrl(), excelEnums.getType());
            Object ob=excelService.commonUpload(multipartFile, excelDto, null,equest);
            return ResponseHelper.buildResponse(ob);
        } catch (RuntimeException e) {
            e.printStackTrace();
            throw new BadRequest(e.getMessage());
        } catch (Exception e) {
            throw new BadRequest("文件格式不正确或excel 模板不匹配！");
        }

    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "下载模板")
    @GetMapping("/downloadnew/template")
    public void downloadnew(HttpServletResponse response) {
        try {
            ExcelEnums excelEnums = ExcelEnums.getByKey(JCDWRYTP);
            ExcelDto excelDto = new ExcelDto(excelEnums.getFileName(), excelEnums.getSheetName(),
                    excelEnums.getClassUrl(), excelEnums.getType());
            excelService.templateExport(response, excelDto);
        } catch (Exception e) {
            e.printStackTrace();
            throw new BadRequest(ExceptionEnum.PARAMETER_TYPE_ERR.getEmsg());
        }
    }





}
