package com.yeejoin.amos.latentdanger.business.param;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.HashMap;

/**
 * @author DELL
 */
public class PageParam<K, V> extends HashMap<K, V> implements Pageable {

    /**
     * 页号（大于等于0）
     */
    protected int current = 1;

    /**
     * 每页大小（大于等于0）
     */
    protected int size = 10;

    /**
     * 起始索引
     */
    protected int offset = 0;

    /**
     * 排序
     */
    protected Sort sort = null;

    public PageParam() {
        this.current = 1;
        this.size = 10;
        this.offset = size * current;
    }

    public PageParam(int current, int size) {
        this.current = current;
        this.size = size;
        this.offset = size * current;
    }

    public PageParam(int current, int size, Sort sort) {
        this.current = current;
        this.size = size;
        this.sort = sort;
        this.offset = size * current;
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getSize() {
        return size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int getPageNumber() {
        return 0;
    }

    @Override
    public int getPageSize() {
        return 0;
    }

    @Override
    public long getOffset() {
        return 0;
    }

    @Override
    public Sort getSort() {
        return null;
    }

    @Override
    public Pageable next() {
        return null;
    }

    @Override
    public Pageable previousOrFirst() {
        return null;
    }

    @Override
    public Pageable first() {
        return null;
    }

    @Override
    public boolean hasPrevious() {
        return false;
    }

    public int getParamPageCurrent() {
        if (ValidationUtil.isEmpty(this.get("current"))) {
            return current;
        }
        if (this.get("current") instanceof String) {
            return Integer.parseInt((String) this.get("current"));
        } else {
            return (Integer)(this.get("current"));
        }
    }

    public int getParamPageSize() {
        if (ValidationUtil.isEmpty(this.get("size"))) {
            return size;
        }
        if (this.get("size") instanceof String) {
            return Integer.parseInt((String) this.get("size"));
        } else {
            return (Integer)(this.get("size"));
        }
    }
}
