package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 三环系统-车辆信息表
 *
 * @author system_generator
 * @date 2024-11-08
 */
@Data
@Accessors(chain = true)
@TableName("tzs_sh_car")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ShCar {

    private static final long serialVersionUID = 1L;

    /**
     * seq
     */
    @TableField(value = "\"SEQUENCE_NBR\"")
    @TableId(
            value = "\"SEQUENCE_NBR\"",
            type = IdType.ID_WORKER
    )
    private String sequenceNbr;

    /**
     * 登记机关
     */
    @TableField(value = "\"REGISTRATION_AGENCY\"")
    private String registrationAgency;

    /**
     * 登记机关代码
     */
    @TableField(value = "\"REGISTRATION_AGENCY_CODE\"")
    private String registrationAgencyCode;

    /**
     * 使用登记证代码
     */
    @TableField(value = "\"USE_REGISTRATION_CODE\"")
    private String useRegistrationCode;

    /**
     * 气瓶安装日期
     */
    @TableField(value = "\"INSTALL_START_DATE\"")
    private Date installStartDate;

    /**
     * 车辆属性
     * A 代表 私家车  B代表公交车  C代表快捷货运  H 代表营运车  P代表公务车  V 代表微型货运车 X代表 其他   T代表出租车 J代表教练车
     */
    @TableField(value = "\"VEHICLE_ATTRIBUTE\"")
    private String vehicleAttribute;

    /**
     * 车牌号
     */
    @TableField(value = "\"CAR_NUMBER\"")
    private String carNumber;

    /**
     * 车架号
     */
    @TableField(value = "\"FRAME_NUMBER\"")
    private String frameNumber;

    /**
     * 登记日期
     */
    @TableField(value = "\"REG_DATE\"")
    private Date regDate;

    /**
     * 停用日期
     */
    @TableField(value = "\"DEA_DATE\"")
    private Date deaDate;

    /**
     * 发动机号
     */
    @TableField(value = "\"ENGINE_NUMBER\"")
    private String engineNumber;

    /**
     * 气瓶数量
     */
    @TableField(value = "\"BATCH_QUANTITY\"")
    private Integer batchQuantity;

    /**
     * 车辆品牌型号
     */
    @TableField(value = "\"VEHICLE_BRAND_MODEL\"")
    private String vehicleBrandModel;

    /**
     * 证打印标识
     */
    @TableField(value = "\"CERTIFICATE_PRINT_FLAG\"")
    private String certificatePrintFlag;

    /**
     * 联系人
     */
    @TableField(value = "\"CONTACT_PERSON\"")
    private String contactPerson;

    /**
     * 联系电话
     */
    @TableField(value = "\"CONTACT_PHONE\"")
    private String contactPhone;

    /**
     * 所有人
     */
    @TableField(value = "\"OWNER\"")
    private String owner;

    /**
     * 安装单位
     */
    @TableField(value = "\"INSTALLATION_UNIT\"")
    private String installationUnit;

    /**
     * 改装车是否打印备案通知单
     * 原装车 忽略看
     */
    @TableField(value = "\"IF_FLAG\"")
    private String ifFlag;

    /**
     * 第一次打印证日期
     */
    @TableField(value = "\"PRINT_DATE\"")
    private Date printDate;

    /**
     * 充装介质
     */
    @TableField(value = "\"MEDIA\"")
    private String media;

    /**
     * 最新检验报告编号
     */
    @TableField(value = "\"LAST_INSPECT_REPORT_NO\"")
    private String lastInspectReportNo;

    /**
     * 气瓶状态
     * 0正常 1变更  2报废  3注销  4启用 5停用  6注销
     */
    @TableField(value = "\"STATE\"")
    private Integer state;

    /**
     * 登记单位
     */
    @TableField(value = "\"REG_UNIT\"")
    private String regUnit;

    /**
     * 总容积
     */
    @TableField(value = "\"TOTAL_VOLUME\"")
    private String totalVolume;

    /**
     * 监检/检验单位
     */
    @TableField(value = "\"INSPECTION_UNIT\"")
    private String inspectionUnit;

    /**
     * 气瓶加装方式
     */
    @TableField(value = "\"CYLINDER_INSTALLATION_METHOD\"")
    private String cylinderInstallationMethod;

    /**
     * 住址
     */
    @TableField(value = "\"ADDRESS\"")
    private String address;

    /**
     * 上一次检验报告编号
     */
    @TableField(value = "\"PREVIOUS_INSPECTION_REPORT_NUMBER\"")
    private String previousInspectionReportNumber;

    /**
     * 是否认领 1已认领 0未认领
     */
    @TableField(value = "\"CLAIMED_FLAG\"")
    private String claimedFlag;

}
