package com.yeejoin.amos.boot.module.jg.api.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.dto.CountDto;
import com.yeejoin.amos.boot.biz.common.dto.KeyValueDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.jg.api.bo.JgBizCountDataBO;
import com.yeejoin.amos.boot.module.jg.api.dto.DynamicColumnDto;
import com.yeejoin.amos.boot.module.jg.api.dto.EquipmentClassifyDto;
import com.yeejoin.amos.boot.module.jg.api.dto.ReportAnalysisSearchDTO;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 装备分类 Mapper 接口
 *
 * @author system_generator
 * @date 2021-10-20
 */
public interface CommonMapper extends BaseMapper<EquipmentCategory> {

    List<Map<String, Object>> getUnitListByType(String type);

    List<Map<String, Object>> getSecurityAdmin(String companyCode, List<String> post);

    Integer checkEquCodeUniqueness(String equCode);

    Map<String, Object> getUserInfo(String sequenceNbr);

    Map<String, Object> getEnterpriseInfo(String useCode);

    List<Map<String, Object>> getCylinderStationInfo(String orgCode);

    List<Map<String, Object>> getVehicleCylinderInfo(String useCode);

    List<Map<String, Object>> getEnterpriseEmployee(String unitCode);

    String getOrgCodeByCompanyCode(String companyCode);

    String getCompanyNameByOrgCode(String orgCode);

    CompanyBo queryCompanyByOrgCode(String orgCode);

    CompanyBo queryCompanyByCode(String companyCode);

    String selectBusinessData(String tableName, String instanceId);

    String selectPromoterData(String tableName, String instanceId);

    void updateBusinessData(String tableName, String assignee, String transferToUserIds, String instanceId, String nextTaskId);

    Map<String, Object> getUserPhone(String name, String companyCode);


    List<Map<String, String>> equOnJgServiceOperationRecords(String record);

    /**
     * 统计指定设备流程中的引用次数（12个流程中，非待提交、非已撤回、非已驳回）
     *
     * @param record 设备唯一标识
     * @return 被引用次数 > 0 则设备不可编辑
     */
    Integer countEquipInUseTimesForEdit(String record);


    /**
     * 统计设备被引用的次数（只有存在就算引用-作废除外）
     *
     * @param record 设备唯一标识
     * @return 被引用次数 > 0 则设备不可删除
     */
    Integer countEquipInUseTimesWithOutZF(String record);

    /**
     * 查询使该设备变为已纳管的业务的数量 [> 0,则纳管状态不需要更新][< 0,则纳管状态需要更新]
     * @param record 设备唯一标识
     * @return 使设备变为已纳管设备的的业务数量
     */
    Integer countEquipInUseTimesForDiscard(String record);

    List<String> refreshTheDetailsDataOfCompletedUsageRegistration(String since);

    /**
     * 按照 地市或者区县查询所在的地市code
     *
     * @param receiveCompanyCode 地市或者区县code
     * @param exclusionIds       需要排除的区县
     * @return 地市code
     */
    String selectCityCompanyCode(@Param("receiveCompanyCode") String receiveCompanyCode, @Param("exclusionIds") String[] exclusionIds);


    /**
     * 告知业务统计
     *
     * @param reportAnalysisSearchDTO 条件
     * @return 过程数据
     */
    List<JgBizCountDataBO> queryForNoticeCountData(@Param("param") ReportAnalysisSearchDTO reportAnalysisSearchDTO);

    List<CompanyBo> queryJGCompanyCodeName(String orgCode);

    /**
     * 维保备案统计数据查询
     *
     * @param reportAnalysisSearchDTO 检索条件
     * @return List<JgBizCountDataBO>
     */
    List<JgBizCountDataBO> queryForMaintenanceCountData(@Param("param") ReportAnalysisSearchDTO reportAnalysisSearchDTO);

    /**
     * 登记类统计数据查询
     *
     * @param reportAnalysisSearchDTO 检索条件
     * @return List<JgBizCountDataBO>
     */
    List<JgBizCountDataBO> queryForRegisterCountData(@Param("param") ReportAnalysisSearchDTO reportAnalysisSearchDTO);


    /**
     * 单位详情
     *
     * @param companyCode
     * @return CompanyBo
     */
    CompanyBo queryCompanyInfoByCode(String companyCode);

    /**
     * 车用气瓶登记业务办理里面的 出厂编号/产品编码 要校验唯一性（产品编号在车用气瓶范围内全局唯一）
     *
     * @param factoryNum
     * @return
     */
    Integer checkFactoryNumUniquenessForVehicleCylinder(String factoryNum, String sequenceNbr);

    /**
     * 查询出厂编码是否重复
     *
     * @param factoryNum 出厂编码
     * @param record     设备record
     * @return Integer
     */
    Integer checkFactoryNumUnique(@Param("factoryNum") String factoryNum,
                                  @Param("record") String record,
                                  @Param("produceUnitCreditCode") String produceUnitCreditCode);

    /**
     * 查询出厂编码是否重复
     *
     * @param factoryNum 出厂编码
     * @return Integer
     */
    List<Map<String, Object>> checkFactoryNumUniqueWithUseName(@Param("factoryNum") String factoryNum,
                                            @Param("produceUnitCreditCode") String produceUnitCreditCode);

    /**
     * 使用登记证编号全库唯一校验
     *
     * @param useRegistrationCode
     * @return
     */
    Integer useRegistrationCertificateAccountUnique(@Param("useRegistrationCode") String useRegistrationCode, @Param("equipId") String equipId);

    String isRegistrationNumberUsedByOtherUnits(@Param("useRegistrationCode") String useRegistrationCode, @Param("companyCode") String companyCode);

    List<String> isRegistrationNumberUsedByOtherUnits2(@Param("useRegistrationCode") String useRegistrationCode, @Param("companyCode") String companyCode);

    /**
     * 查询维保超期的设备
     */
    List<Map<String, Object>> queryOutOfMaintenanceRecord();

    /**
     * 查询巡检超期的设备
     */
    List<Map<String, Object>> queryOutOfInspectionRecord();

    /**
     * 查询许可超期的企业
     */
    List<Map<String, Object>> queryOutOfQualificationRecord();

    /**
     * 查询资质超期的证书
     **/
    List<Map<String, Object>> queryOutOfCertificationRecord();

    List<Map<String, Object>> queryOverDesignLifeRecord(Date since);

    List<Map<String, Object>> queryOverDesignLifeAgainRecord(Date since);

    /**
     * 大屏业务全过程统计已经完成的单据
     *
     * @param orgCode          行政区划对应公司的orgCode
     * @param dpFilterParamDto 过滤条件
     * @return 统计数量数组
     */
    List<Long> countBizFinishedNumForDP(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    List<Long> countBizFinishedNumForDPAZGZ(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    List<Long> countBizFinishedNumForDPJDJY(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    List<Long> countBizFinishedNumForDPSYDJ(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    List<Long> countBizFinishedNumForDPDQJY(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    List<Long> countBizFinishedNumForDPBGDJ(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    List<Long> countBizFinishedNumForDPZXBX(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    /**
     * 大屏大屏业务全过程统计流程中(包括已经完成)的单据
     *
     * @param orgCode          行政区划对应公司的orgCode
     * @param dpFilterParamDto 过滤条件
     * @return 统计数量数组
     */
    List<Long> countAllInFlowingForDPNoFinishedBizData(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    List<Long> countAllInFlowingForDPNoFinishedBizDataAZGZ(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    List<Long> countAllInFlowingForDPNoFinishedBizDataJDJY(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    List<Long> countAllInFlowingForDPNoFinishedBizDataSYDJ(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    List<Long> countAllInFlowingForDPNoFinishedBizDataDQJY(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    List<Long> countAllInFlowingForDPNoFinishedBizDataBGDJ(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    List<Long> countAllInFlowingForDPNoFinishedBizDataZXBX(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    /**
     * 大屏业务全过程统计已经完成的列表
     *
     * @param orgCode                   行政区划对应公司的orgCode
     * @param dpFilterParamForDetailDto 过滤条件
     * @return 统计数量数组
     */
    Page<Map<String, Object>> countBizFinishedNumForDPList(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamForDetailDto);

    Page<Map<String, Object>> countBizFinishedNumForDPListAZGZ(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamForDetailDto);

    Page<Map<String, Object>> countBizFinishedNumForDPListJDJY(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamForDetailDto);

    Page<Map<String, Object>> countBizFinishedNumForDPListSYDJ(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamForDetailDto);

    Page<Map<String, Object>>  countBizFinishedNumForDPListDQJY(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamForDetailDto);

    Page<Map<String, Object>> countBizFinishedNumForDPListBGDJ(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamForDetailDto);

    Page<Map<String, Object>> countBizFinishedNumForDPListZXBX(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamForDetailDto);


    void updateTechParamDynamic(@Param(value = "tableName") String tableName, @Param(value = "record") String record, @Param(value = "columns") List<DynamicColumnDto> columns);

    /**
     * 当前设备在流程中的申请单号
     *
     * @param record 设备id
     * @return 申请单号
     */
    List<String> findEquipInUseService(@Param("record") String record);


    /**
     * 查询指定设备，使用登记后，后续业务的数据
     *
     * @param equipTransferId 使用登记主表id
     * @return 后续业务数量
     */
    Long countBizNumAfterUseReg(@Param("equipTransferId") String equipTransferId);

    /**
     * 车用气瓶-使用登记证编号全库唯一校验
     *
     * @param useRegistrationCode 使用登记证编号
     * @param record              设备record
     * @return 匹配到的数据，包含设备的企业信息
     */
    List<Map<String, String>> useRegCertAccountUniqueWithVehGasCyl(@Param("useRegistrationCode") String useRegistrationCode,
                                                                   @Param("record") String record);

    /**
     * 车用气瓶-车辆VIN全库唯一校验
     *
     * @param VIN    车辆VIN码
     * @param record 设备record
     * @return 匹配到的数据，包含设备的企业信息
     */
    List<Map<String, String>> VINAccountUniqueWithVehGasCyl(@Param("VIN") String VIN,
                                                            @Param("record") String record);

    void updateEnterpriseSafetyStatus(@Param("useUnitCodeList") Set<String> useUnitCodeList);

    List<EquipmentClassifyDto> getEquClassifyByCode(@Param("parentCode") String parentCode);

    /**
     * 查询通过企查查查询的公司信息代码字典
     * @return 公司对象集合
     */
    List<KeyValueDto> queryAllCompanyDict();

    Integer checkRecordUniqueness(String record);

    String queryUnitCreditInfoBySeq(String unitSeq);

    String queryUnitInfoByCreditCode(String unitCreditCode);

    List<Map<String, Object>> getUnitInfoListByType(String type);

    String queryUnitCreditCodeBySeq(String unitSeq);

    String queryUnitNameByCreditCode(String unitCreditCode);

    List<CountDto> countBizNumAfterUseRegBatchEquip(@Param("records") List<String> records);

    /**
     * 查询指定的装置集合是否发生过后续业务：使用登记流程中、其他后续业务非已作废、已完成
     * @param projectContraptionIds 装置ids
     * @return 是否发生后续业务
     */
    List<CountDto> countBizNumAfterUseRegBatchProjectContraption(@Param("projectContraptionIds") List<Long> projectContraptionIds);

    List<Map<String, String>> gdEquOnJgServiceOperationRecords(@Param("record") String record);

    /**
     * 用户绑定设备数量
     *
     * @param userSeq 用户userId
     * @return 数量
     */
    @Select("SELECT count(1) from tzs_user_equip where user_seq = #{userSeq}")
    Integer queryUserBindEquNum(@Param("userSeq") String userSeq);

    /**
     * 根据设备RECORD查询最近一次安装告知或使用登记或车用气瓶登记的接收机构代码
     *
     * @param record
     * @return
     */
    List<Map<String, String>> queryRecentlyReceiveCompanyCode(String record);

    Integer countEquipInUseTimesForXaElevator(String record);
}

