package com.yeejoin.equipmanage.service.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.equipmanage.common.entity.EquipmentPoint;
import com.yeejoin.equipmanage.common.entity.vo.VideoDownloadVO;
import com.yeejoin.equipmanage.dto.EquipmentDetailDownloadTemplateDto;
import com.yeejoin.equipmanage.dto.ExcelDto;
import com.yeejoin.equipmanage.service.IEquipmentPointService;
import com.yeejoin.equipmanage.service.IExcelService;
import com.yeejoin.equipmanage.service.IStockService;
import com.yeejoin.equipmanage.utils.ExcelUtil;

import lombok.extern.slf4j.Slf4j;

@Service("excelService")
@Slf4j
public class ExcelServiceImpl implements IExcelService {

    @Autowired
    private IEquipmentPointService iEquipmentPointService;

    @Autowired
    private VideoServiceImpl videoService;

    @Autowired
    @Lazy
    IStockService iStockService;

    /**
     * 导出消防点位数据
     *
     * @param paramsMap
     * @return
     */
    @Override
    public List<EquipmentPoint> exportPointData(Map<String, Object> paramsMap) {
        List<EquipmentPoint> list = iEquipmentPointService.listBySearchMap(paramsMap);
        return list;
    }

    @Override
    public Object commonUpload(MultipartFile multipartFile, ExcelDto excelDto, ReginParams reginParams, AgencyUserModel agencyUserModel) {
        Object  date="";
        switch (excelDto.getType()) {
            case "XFZB":
                try {
                    date= excelImportFireEquipment(multipartFile, reginParams, agencyUserModel);
                } catch (Exception e) {
                    throw new BadRequest(e.getMessage());
                }
                break;
            case "JKXX":
                try {
                    excelImporVideo(multipartFile);
                } catch (Exception e) {
                    log.error(e.getMessage(), e);
                    throw new BadRequest(e.getMessage());
                }
                break;
        }
        return  date;
    }

    private Object excelImportFireEquipment(MultipartFile multipartFile, ReginParams reginParams, AgencyUserModel agencyUserModel) throws Exception {

         Object date="";
        List<EquipmentDetailDownloadTemplateDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile,
                EquipmentDetailDownloadTemplateDto.class, 1);

        if (excelDtoList != null && excelDtoList.size() > 0) {
            date=iStockService.uploadListByTemplate(excelDtoList, reginParams, agencyUserModel);
        } else {
            throw new BadRequest("请填写数据后再上传！");
        }
        return date;
    }

    private void excelImporVideo(MultipartFile multipartFile) throws Exception {

        List<VideoDownloadVO> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile,
                VideoDownloadVO.class, 1);

        if (excelDtoList != null && excelDtoList.size() > 0) {
            videoService.videoUpload(excelDtoList);
        } else {
            throw new BadRequest("请填写数据后再上传！");
        }
    }


}
