package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.jg.api.dto.JgReformNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgReformNotice;
import com.yeejoin.amos.boot.module.jg.api.service.IJgInstallationNoticeService;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgReformNoticeServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;
import java.util.Objects;

/**
 * 改造告知
 *
 * @author system_generator
 * @date 2023-12-19
 */
@RestController
@Api(tags = "改造告知Api")
@RequestMapping(value = "/jg-reform-notice")
public class JgReformNoticeController extends BaseController {

    @Autowired
    JgReformNoticeServiceImpl jgReformNoticeService;

    @Autowired
    IJgInstallationNoticeService iJgInstallationNoticeService;

    /**
     * 新增改造告知
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增改造告知", notes = "新增改造告知")
    public ResponseModel<Object> save(@RequestParam String submitType, @RequestBody Map<String, Object> model) {
        ReginParams reginParams = getSelectedOrgInfo();
        return ResponseHelper.buildResponse(jgReformNoticeService.saveNotice(submitType, model, reginParams));
    }


    /**
     * 更新
     *
     * @param submitType       更新或提交
     * @param installationInfo 改造告知信息
     * @param op               参数
     * @return JgReformNoticeDto
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/update")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新改造告知", notes = "根据sequenceNbr更新改造告知")
    public ResponseModel<JgReformNoticeDto> updateBySequenceNbrJgReformNotice(@RequestParam String submitType, @RequestBody JgReformNoticeDto installationInfo, @RequestParam(value = "op", required = false) String op) {
        if (Objects.isNull(installationInfo)) {
            throw new IllegalArgumentException("参数installationInfo不能为空");
        }

        return ResponseHelper.buildResponse(jgReformNoticeService.updateInstallationNotice(submitType, installationInfo, op));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除改造告知", notes = "根据sequenceNbr删除改造告知")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam(value = "sequenceNbr") Long[] sequenceNbr) {
        return ResponseHelper.buildResponse(jgReformNoticeService.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr批量删除
     *
     * @param sequenceNbrs 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/batchDelete")
    @ApiOperation(value = "根据sequenceNbr删除维保合同备案", notes = "根据sequenceNbr删除维保合同备案")
    public ResponseModel<Boolean> deleteForBatch(@RequestParam("sequenceNbrs") Long[] sequenceNbrs) {
        try {
            return ResponseHelper.buildResponse(jgReformNoticeService.deleteForBatch(sequenceNbrs));
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个改造告知", notes = "根据sequenceNbr查询单个改造告知")
    public ResponseModel<Map<String, Object>> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgReformNoticeService.queryBySequenceNbr(sequenceNbr));
    }


    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "POST", value = "改造告知分页查询", notes = "改造告知分页查询")
    public ResponseModel<Page<JgReformNoticeDto>> queryForPage(
            @ApiParam(value = "当前页码", required = true) @RequestParam(value = "current", defaultValue = "1") int current,
            @ApiParam(value = "每页大小", required = true) @RequestParam(value = "size", defaultValue = "20") int size,
            @RequestBody(required = false) JgReformNoticeDto model
    ) {
        Page<JgReformNotice> page = new Page<>(current, size);
        ReginParams reginParams = getSelectedOrgInfo();
        String type = (String) iJgInstallationNoticeService.getCompanyType().get("companyLevel");
        return ResponseHelper.buildResponse(jgReformNoticeService.queryForJgReformNoticePage(page, model, type, reginParams));
    }

    /**
     * 生成告知单
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "改造告知列表全部数据查询", notes = "改造告知列表全部数据查询")
    @GetMapping(value = "/generate-report")
    public ResponseModel<String> generateReport(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgReformNoticeService.generateInstallationNoticeReport(sequenceNbr));
    }
}
