package com.yeejoin.amos.api.openapi.face.model;

import java.util.Date;

import org.typroject.tyboot.core.rdbms.model.BaseModel;

import lombok.Data;
import lombok.EqualsAndHashCode;
/**
 * <p>
 * 电梯故障表
 * </p>
 *
 * @author 子杨
 * @since 2021-09-28
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ElevatorAlarmModel extends BaseModel {

        /**
	 * <pre>
	 * 
	 * </pre>
	 */
	private static final long serialVersionUID = 1974821977890729965L;
        /**
         * 电梯注册码
         */
    private String registerCode;
	    /**
	     * 电梯应急救援识别码
	     */
    private Integer rescueCode;
	    /**
		 * 所属省
		 */
	private String province;
		/**
		 * 所属地市
		 */
	private String city;
		/**
		 * 所属区县
		 */
	private String district;
		/**
		 * 电梯地址
		 */
	private String address;
		/**
		 * 设备分类
		 */
	private String deviceCategory;
        /**
         * 原始故障编号
         */
    private String faultId;
        /**
         * 故障发生时间字符串(格式为：yyyymmddhhmmss)
         */
    private String startTime;
	    /**
	     * 故障发生时间
	     */
	private Date startDate;
        /**
         * 故障类型编码
         */
    private String type;
	    /**
	     * 故障类型名称
	     */
	private String typeName;
        /**
         * 处置状态。0：处置完成。1：故障发生 2：发出通知 3：处置响应 4：处置到场 5：误报
         */
    private Integer dealStatus;
        /**
         * 处置时间字符串(格式为：yyyymmddhhmmss)
         */
    private String dealTime;
	    /**
	     * 处置时间
	     */
	private Date dealDate;
        /**
         * 处置人
         */
    private Integer dealPerson;
        /**
         * 现场确认是否困人。0：不困人，1：困人
         */
    private Integer isTrap;
        /**
         * 是否自恢复 0：否1：是
         */
    private Integer selfrepair;
        /**
         * 故障发生时的总接触器吸合或是断开。0：吸合，1：断开
         */
    private Integer dealNote;
        /**
         * 是否自恢复 0：否1：是
         */
    private Integer mainContactor;
        /**
         * 故障发生时的运行接触器吸合或是断开。0：吸合，1：断开
         */
    private Integer runContactor;
        /**
         * 故障发生时的安全回路是否断开 0：正常，1：断开
         */
    private Integer circuit;
        /**
         * 故障发生时的轿厢运行状态。1：停止，2：运行
         */
    private Integer carStatus;
        /**
         * 故障发生时的方向。1：无方向 2：上行 3：下行
         */
    private Integer direction;
        /**
         * 故障发生时的轿厢是否在门区。1：轿厢在门区 0：轿厢在非门区
         */
    private Integer isZone;
        /**
         * 故障发生时的当前物理楼层
         */
    private Integer floor;
        /**
         * 故障发生时的关门到位 1：关门到位，0：无关门到位信号
         */
    private Integer doorStatus;
        /**
         * 故障发生时的上极限是否动作 0:否，1：是
         */
    private Integer upLimit;
        /**
         * 故障发生时的下极限是否动作 0:否，1：是
         */
    private Integer downLimit;
        /**
         * 故障发生时的轿厢报警按钮是否动作 0:否，1：是
         */
    private Integer alarm;
        /**
         * 累计运行小时数，保留到小数点后两位
         */
    private Double hours;
        /**
         * 累计运行次数
         */
    private Integer runCount;
        /**
         * 操作人名称
         */
    private String recUserName;
        /**
         * 是否删除
         */
    private Boolean isDelete;

}
