package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.reformNotice;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.entity.JgReformNotice;
import com.yeejoin.amos.boot.module.jg.api.entity.JgReformNoticeEq;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgReformNoticeEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgReformNoticeServiceImpl;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class ReformNoticeEditUpdateService {

    private final JgReformNoticeServiceImpl jgReformNoticeService;

    private final JgReformNoticeEqServiceImpl jgReformNoticeEqService;

    public Set<String> getEqsByApplyNo(String applyNo) {
        JgReformNotice jgInstallationNotice = jgReformNoticeService.getOne(new LambdaQueryWrapper<JgReformNotice>().eq(JgReformNotice::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr));
        List<JgReformNoticeEq> eqs = jgReformNoticeEqService.list(new LambdaQueryWrapper<JgReformNoticeEq>().eq(JgReformNoticeEq::getEquipTransferId, jgInstallationNotice.getSequenceNbr()).select(JgReformNoticeEq::getEquId, BaseEntity::getSequenceNbr));
        return eqs.stream().map(JgReformNoticeEq::getEquId).collect(Collectors.toSet());
    }

    public JgReformNotice getOneByApplyNo(String applyNo) {
        return jgReformNoticeService.getOne(new LambdaQueryWrapper<JgReformNotice>().eq(JgReformNotice::getApplyNo, applyNo));
    }

}