package com.yeejoin.amos.patrol.business.service.impl;

import com.yeejoin.amos.boot.biz.common.constants.RuleConstant;
import com.yeejoin.amos.component.rule.RuleTrigger;
import com.yeejoin.amos.patrol.business.dto.MsgRo;
import com.yeejoin.amos.patrol.business.param.PushMsgParam;
import com.yeejoin.amos.patrol.business.util.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @Author: hll
 * @Description: 消防巡查触发规则
 * @Date: 2021/11/10 9:50
 */
@Service
public class RulePlanService {

    private final String packageId = "消息/addCheckRule";
    private final String msgType = "patrolSystem";
    private final String APP = "APP";
    private final String WEB = "WEB";
    private final String APP_WEB = "APP/WEB";

    @Autowired
    private RuleTrigger ruleTrigger;

    public Boolean sendRule(PushMsgParam pushMsgParam) {
        MsgRo msgRo = new MsgRo();
        msgRo.setName(pushMsgParam.getSubject());
        msgRo.setContent(pushMsgParam.getContent());
        msgRo.setRecivers(pushMsgParam.getRecivers());
        msgRo.setMsgType(msgType);
        msgRo.setTerminal(APP_WEB);
        msgRo.setSendTime(DateUtil.date2LongStr(new Date()));
        msgRo.setRelationId(pushMsgParam.getRelationId());
        msgRo.setExtras(pushMsgParam.getExtras());
        msgRo.setIsSendApp(true);
        msgRo.setIsSendWeb(true);
        msgRo.setCategory(RuleConstant.NOTIFY);
        //触发规则
        try {
            ruleTrigger.publish(msgRo, packageId, new String[0]);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

}
