package com.yeejoin.amos.boot.module.cylinder.api.entity;

import java.util.Date;

import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 特种设备基本信息-制造信息
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
@Accessors(chain = true)
@TableName("tz_jg_produce_info")
@ApiModel(value = "TzsJgProduceInfo对象", description = "特种设备基本信息-制造信息")
public class TzsJgProduceInfo extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "设备唯一标识码")
	private String sequenceCode;

	@ApiModelProperty(value = "监管系统唯一编码")
	private String superviseCode;

	@ApiModelProperty(value = "制造单位统一社会信用代码")
	private String produceUnitCreditCode;

	@ApiModelProperty(value = "制造单位名称")
	private String produceUnitName;

	@ApiModelProperty(value = "制造许可编号")
	private String produceLicenseNum;

	@ApiModelProperty(value = "出厂编号")
	private String factoryNum;

	@ApiModelProperty(value = "制造日期")
	private Date produceDate;

	@ApiModelProperty(value = "是否进口(是、否)")
	private String imported;

	@ApiModelProperty(value = "制造国")
	private String produceCountry;

	@ApiModelProperty(value = "监督检验ID")
	private String inspectionId;

	@ApiModelProperty(value = "型式试验ID")
	private String typeTestId;

	@ApiModelProperty(value = "同步时间")
	private Date syncDate;

	@ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
	private Integer syncState;

	@ApiModelProperty(value = "对接公司编码")
	private String appId;

}
