package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.biz.reminder.core.IReminderHandler;
import com.yeejoin.amos.boot.module.jg.api.dto.ReminderItemDto;
import com.yeejoin.amos.boot.module.jg.biz.reminder.service.RemindServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

@RestController
@RequestMapping(value = "/biz-reminder")
@Api(tags = "业务数据项提醒控制器")
@RequiredArgsConstructor
public class BizReminderController {

    private final RemindServiceImpl remindService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/v1/{bizType}/page")
    @ApiOperation(value = "缺失数据项分页", httpMethod = "POST")
    public ResponseModel<IPage<?>> reminderPageList(@RequestParam(value = "current") int current,
                                                    @RequestParam(value = "size") int size,
                                                    @ApiParam(value = "单据编号或者设备装置唯一标识") @RequestParam(required = false) String bizId,
                                                    @ApiParam(value = "业务类型") @PathVariable String bizType,
                                                    @ApiParam(value = "生成类型") @RequestParam IReminderHandler.SourceType sourceType,
                                                    @ApiParam(value = "表单数据") @RequestBody(required = false) Map<String, Object> formData) {
        Page<ReminderItemDto> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(remindService.getReminderItems(page, bizId, bizType, sourceType, formData));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/v1/{bizType}/level")
    @ApiOperation(value = "缺失等级查询", httpMethod = "GET")
    public ResponseModel<Integer> getReminderLevel(
            @ApiParam(value = "单据编号或者设备装置唯一标识") @RequestParam String bizId,
            @ApiParam(value = "业务类型") @PathVariable String bizType) {
        return ResponseHelper.buildResponse(remindService.getReminderLevel(bizId, bizType));
    }

}