package com.yeejoin.amos.boot.module.ymt.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.IdxBizJgProjectConstructionServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ymt.api.dto.IdxBizJgProjectConstructionDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 工程装置-施工信息表
 *
 * @author system_generator
 * @date 2024-12-12
 */
@RestController
@Api(tags = "工程装置-施工信息表Api")
@RequestMapping(value = "/idx-biz-jg-project-construction")
public class IdxBizJgProjectConstructionController extends BaseController {

    @Autowired
    IdxBizJgProjectConstructionServiceImpl idxBizJgProjectConstructionServiceImpl;

    /**
     * 新增工程装置-施工信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增工程装置-施工信息表", notes = "新增工程装置-施工信息表")
	public ResponseModel<IdxBizJgProjectConstructionDto> save(@RequestBody IdxBizJgProjectConstructionDto model) {
	    model = idxBizJgProjectConstructionServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新工程装置-施工信息表", notes = "根据sequenceNbr更新工程装置-施工信息表")
	public ResponseModel<IdxBizJgProjectConstructionDto> updateBySequenceNbrIdxBizJgProjectConstruction(@RequestBody IdxBizJgProjectConstructionDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(idxBizJgProjectConstructionServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除工程装置-施工信息表", notes = "根据sequenceNbr删除工程装置-施工信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(idxBizJgProjectConstructionServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个工程装置-施工信息表",  notes = "根据sequenceNbr查询单个工程装置-施工信息表")
	public ResponseModel<IdxBizJgProjectConstructionDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(idxBizJgProjectConstructionServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "工程装置-施工信息表分页查询",  notes = "工程装置-施工信息表分页查询")
	public ResponseModel<Page<IdxBizJgProjectConstructionDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<IdxBizJgProjectConstructionDto> page = new Page<IdxBizJgProjectConstructionDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(idxBizJgProjectConstructionServiceImpl.queryForIdxBizJgProjectConstructionPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "工程装置-施工信息表列表全部数据查询",   notes = "工程装置-施工信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<IdxBizJgProjectConstructionDto>> selectForList() {
	    return ResponseHelper.buildResponse(idxBizJgProjectConstructionServiceImpl.queryForIdxBizJgProjectConstructionList());
	}
}
