package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;


@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "管道-设备信息", description = "管道-设备信息")
public class PipingExcelDto extends BaseDto {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;


    //----------------------------------------------------------------------基本信息

    @ApiModelProperty(value = "设备种类")
    @ExcelIgnore
    private String equList;

    @ApiModelProperty(value = "设备类别")
    @ExcelIgnore
    private String equCategory;

    @ApiModelProperty(value = "设备品种")
    @ExcelIgnore
    private String equDefine;

    @ApiModelProperty(value = "单位内编号")
    @ExcelProperty(value = "单位内编号")
    private String useInnerCode;

    @ApiModelProperty(value = "产品名称")
    @ExcelProperty(value = "产品名称")
    private String productName;

    @ApiModelProperty(value = "管道名称（登记单元）")
    @ExcelProperty(value = "管道名称（登记单元）")
    private String pipeName;

    @ApiModelProperty(value = "设备型号")
    @ExcelProperty(value = "设备型号")
    private String equType;

    @ApiModelProperty(value = "设备总价值（万元）")
    @ExcelProperty(value = "设备总价值（万元）")
    private String equPrice;


    @ApiModelProperty(value = "有无设备代码")
    @ExcelProperty(value = "有无设备代码")
    private String equCodeType;

    @ApiModelProperty(value = "设备代码")
    @ExcelProperty(value = "设备代码")
    private String equCode;

    @ApiModelProperty(value = "工程（装置）名称")
    @ExcelProperty(value = "工程（装置）名称")
    private String projectContraption;


    @ApiModelProperty(value = "工程（装置）编号")
    @ExcelProperty(value = "工程（装置）编号")
    private String projectContraptionNo;

    @ApiModelProperty(value = "使用登记证编号")
    @ExcelProperty(value = "使用登记证编号")
    private String useOrgCode;

    //-----------------------------------------------------------------------使用信息

    @ApiModelProperty(value = "使用单位统一社会信用代码")
    @ExcelProperty(value = "使用单位统一社会信用代码")
    private String useUnitCode;

    @ApiModelProperty(value = "使用单位名称")
    @ExcelProperty(value = "使用单位名称")
    private String useUnit;

    //-----------------------------------------------------------------------安装信息

    @ApiModelProperty(value = "安装单位统一社会信用代码")
    @ExcelProperty(value = "安装单位统一社会信用代码")
    private String uscUnitCreditCode;

    @ApiModelProperty(value = "安装单位名称")
    @ExcelProperty(value = "安装单位名称")
    private String uscUnitName;

    //-----------------------------------------------------------------------检验检测信息

    @ApiModelProperty(value = "检验检测机构统一社会信用代码")
    @ExcelProperty(value = "检验检测机构统一社会信用代码")
    private String inspectOrgCode;

    @ApiModelProperty(value = "检验检测机构名称")
    @ExcelProperty(value = "检验检测机构名称")
    private String inspectOrgName;

    @ApiModelProperty(value = "检验结论")
    @ExcelProperty(value = "检验结论")
    private String inspectConclusion;

    @ApiModelProperty(value = "检验类型")
    @ExcelProperty(value = "检验类型")
    private String inspectType;

    @ApiModelProperty(value = "检验日期")
    @ExcelProperty(value = "检验日期")
    private String inspectDate;

    @ApiModelProperty(value = "检验人员名称")
    @ExcelProperty(value = "检验人员名称")
    private String inspectStaff;

    @ApiModelProperty(value = "下次检验日期")
    @ExcelProperty(value = "下次检验日期")
    private String nextInspectDate;

    @ApiModelProperty(value = "检验报告编号")
    @ExcelProperty(value = "检验报告编号")
    private String inspectReportNo;

    @ApiModelProperty(value = "检验报告附件")
    @ExcelIgnore
    private String inspectReport;

    //-----------------------------------------------------------------------设计信息

    @ApiModelProperty(value = "设计单位统一社会信用代码")
    @ExcelProperty(value = "设计单位统一社会信用代码")
    private String designUnitCreditCode;

    @ApiModelProperty(value = "设计单位名称")
    @ExcelProperty(value = "设计单位名称")
    private String designUnitName;


    //--------------------------------------------------------------------压力管道----技术参数

    @ExcelProperty(value = "管道类别")
    @ApiModelProperty(value = "管道类别")
    private String pipelineClass;

    @ExcelProperty(value = "公称壁厚(mm)")
    @ApiModelProperty(value = "公称壁厚(mm)")
    private String wallThickness;

    @ExcelProperty(value = "公称直径（mm）")
    @ApiModelProperty(value = "公称直径（mm）")
    private String nominalDiameter;

    @ExcelProperty(value = "管道长度（m）")
    @ApiModelProperty(value = "管道长度（m）")
    private String pipeLength;

    @ExcelProperty(value = "设计-压力（MPa）")
    @ApiModelProperty(value = "设计-压力（MPa）")
    private String pressure;

    @ExcelProperty(value = "设计-介质")
    @ApiModelProperty(value = "设计-介质")
    private String medium;

    @ExcelProperty(value = "起/始位置 （经纬度）（格式：经度-纬度）")
    @ApiModelProperty(value = "起/始位置 （经纬度）（格式：经度-纬度）")
    private String startePosition;

    @ExcelProperty(value = "设计-温度（℃）")
    @ApiModelProperty(value = "设计-温度（℃）")
    private String temperature;

    @ExcelProperty(value = "管道编号")
    @ApiModelProperty(value = "管道编号")
    private String pipelineNumber;

    @ExcelProperty(value = "管道级别")
    @ApiModelProperty(value = "管道级别")
    private String deviceLevel;

    @ExcelProperty(value = "工作条件-压力(MPa)")
    @ApiModelProperty(value = "工作条件-压力(MPa)")
    private String workPressure;

    @ExcelProperty(value = "工作条件-温度(℃)")
    @ApiModelProperty(value = "工作条件-温度(℃)")
    private String workTemperature;

    @ExcelProperty(value = "工作条件-介质")
    @ApiModelProperty(value = "工作条件-介质")
    private String workMedium;

    @ExcelProperty(value = "备注")
    @ApiModelProperty(value = "备注")
    private String remarks;

}