package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 安全追溯-起重机械
 *
 * @author system_generator
 * @date 2023-08-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@Group(value = "tech_params_lifting")
public class TechParamsLiftingChangeFieldDto extends BaseTechParamsFieldDto {

    @FieldDisplayDefine(value = "额定载重量")
    private String ratedLoadCapacity;

    @FieldDisplayDefine(value = "额定起重量")
    private String ratedLiftingCapacity;

    @FieldDisplayDefine(value = "最大起重量")
    @TableField("MAX_LIFTING_CAPACITY")
    private String maxLiftingCapacity;

    @FieldDisplayDefine(value = "最大起重力矩")
    @TableField("MAX_LIFTING_TORQUE")
    private String maxLiftingTorque;

    @FieldDisplayDefine(value = "跨度（工作幅度）")
    private String spanWorkingRange;

    @FieldDisplayDefine(value = "起升速度")
    private String liftingSpeed;

    @FieldDisplayDefine(value = "起升高度")
    private String liftingHeight;

    @FieldDisplayDefine(value = "工作级别", dictCode = "GZJB")
    private String workLevel;

    @FieldDisplayDefine(value = "额定起重力矩")
    private String ratedLiftingTorque;

    @FieldDisplayDefine(value = "层数/泊位数")
    private Integer numberStorey;

    @FieldDisplayDefine(value = "运行速度")
    private String runningSpeed;

    @FieldDisplayDefine(value = "大车运行速度")
    private String bigcarRunSpeed;

    @FieldDisplayDefine(value = "小车运行速度")
    private String smallcarrunSpeed;

    @FieldDisplayDefine(value = "额定成员数")
    private Integer ratedMembers;

    @FieldDisplayDefine(value = "额定提升速度")
    private String ratedLiftingSpeed;

    @FieldDisplayDefine(value = "自由端高度")
    private String heightFreeEnd;

    @FieldDisplayDefine(value = "吊笼工作行程")
    private String workStrokeCage;

    @FieldDisplayDefine(value = "存容量")
    private Integer storageCapacity;

    @FieldDisplayDefine(value = "额定升降速度")
    private String ratedLiftSpeed;

    @FieldDisplayDefine(value = "额定横移速度")
    private String ratedTraverseSpeed;

    @FieldDisplayDefine(value = "单车最大(出)车时间")
    @TableField("BICYCLE_MAX_EXIT_TIME")
    private String bicycleMaxExitTime;

    @FieldDisplayDefine(value = "单车最大(进)车时间")
    private String bicycleMaxComeTime;

    @FieldDisplayDefine(value = "区域防爆等级", dictCode = "FBDJ")
    private String explosionProofGrade;

    @FieldDisplayDefine(value = "悬臂长度")
    private String cantileverLength;

    @FieldDisplayDefine(value = "变幅速度")
    private String derrickingSpeed;

    @FieldDisplayDefine(value = "吊笼数量")
    private String hangingCagesNumber;

    @FieldDisplayDefine(value = "燃爆物质")
    private String explosiveSubstance;

    @FieldDisplayDefine(value = "整机防爆标志")
    private String explosionproofSignComplete;

    @FieldDisplayDefine(value = "监检结束高度")
    private String checkFinishedHeight;

    @FieldDisplayDefine(value = "适停车辆尺寸高")
    private String parkingVehicleHeight;

    @FieldDisplayDefine(value = "适停车辆尺寸宽")
    private String parkingVehicleWeight;

    @FieldDisplayDefine(value = "适停车辆尺寸长")
    private String parkingVehicleLength;


    @FieldDisplayDefine(value = "最大工作幅度")
    private String maxSpanWorkingRange;


    @FieldDisplayDefine(value = "最小工作幅度")
    private String minSpanWorkingRange;


    @FieldDisplayDefine(value = "单车最大进（出）车时间")
    private String bicycleMaxComeExitTime;

}
