package com.yeejoin.amos.boot.module.jyjc.biz.result.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.utils.SnowflakeIdUtil;
import com.yeejoin.amos.boot.module.common.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResult;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultAttachment;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultParam;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultParamService;
import com.yeejoin.amos.boot.module.jyjc.biz.event.publisher.BizEmqPublisher;
import com.yeejoin.amos.boot.module.jyjc.biz.result.factory.support.SupportableResultDataProcessor;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionResultServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgInspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgTechParamsPipeline;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgInspectionDetectionInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgProjectContraptionMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgTechParamsPipelineMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.UseInfoMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

@Component
@RequiredArgsConstructor
public class BatchEquipResultDataProcessor implements SupportableResultDataProcessor {

    private final IJyjcInspectionResultParamService iJyjcInspectionResultParamService;

    private final ObjectMapper objectMapper;

    private final IdxBizJgTechParamsPipelineMapper techParamPipelineMapper;

    private final IdxBizJgInspectionDetectionInfoMapper inspectionDetectionInfoMapper;

    private final BizEmqPublisher bizEmqPublisher;

    private final CommonServiceImpl commonService;

    private final SnowflakeIdUtil sequence;

    private final UseInfoMapper useInfoMapper;

    private final JyjcInspectionResultServiceImpl inspectionResultService;

    private final IdxBizJgProjectContraptionMapper idxBizJgProjectContraptionMapper;

    private static final Set<String> SUPPORTED_TYPES = Sets.newHashSet(EquipmentClassifityEnum.YLGD.getCode());

    @Override
    public boolean support(String equList) {
        return SUPPORTED_TYPES.contains(equList);
    }

    @Override
    public void process(JyjcInspectionResult jyjcInspectionResult) {
        Set<String> records = new HashSet<>();
        JyjcInspectionResultParam param = iJyjcInspectionResultParamService.getOneParamByResultSeq(jyjcInspectionResult.getSequenceNbr());
        if (!ObjectUtils.isEmpty(param.getParamJson())) {
            JSONObject paramObj = JSON.parseObject(param.getParamJson());
            try {
                List<Map<String, Object>> equips = objectMapper.readValue(
                        objectMapper.writeValueAsString(paramObj.get("equip")),
                        new TypeReference<ArrayList<Map<String, Object>>>() {
                        }
                );
                equips.forEach(e -> {
                    String record = String.valueOf(e.get("equipId"));
                    records.add(record);
                    // 1.更新管道的技术参数
                    updateTechParams(e, record);
                    // 2.检验信息更新或者插入
                    IdxBizJgInspectionDetectionInfo info = new IdxBizJgInspectionDetectionInfo();
                    LambdaQueryWrapper<IdxBizJgInspectionDetectionInfo> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(IdxBizJgInspectionDetectionInfo::getResultSeq, jyjcInspectionResult.getSequenceNbr());
                    wrapper.eq(IdxBizJgInspectionDetectionInfo::getRecord, record);
                    List<IdxBizJgInspectionDetectionInfo> list = inspectionDetectionInfoMapper.selectList(wrapper);
                    JyjcInspectionResultAttachment jybgFile = inspectionResultService.getReportAttachment(jyjcInspectionResult.getSequenceNbr());
                    if (CollectionUtils.isEmpty(list)) {
                        // 无则插入
                        commonService.buildInspectInfo(jyjcInspectionResult, info, jybgFile, record);
                        info.setSequenceNbr(sequence.nextId() + "");
                        inspectionDetectionInfoMapper.insert(info);
                        // 对方不查询库 所以无事务操作
                        bizEmqPublisher.sendInspectionMsgAfterSave(info, "insert");
                    } else {
                        // 已经维护过则更新
                        info = list.get(0);
                        commonService.buildInspectInfo(jyjcInspectionResult, info, jybgFile, record);
                        inspectionDetectionInfoMapper.updateById(info);
                        // 对方不查询库 所以无事务操作
                        bizEmqPublisher.sendInspectionMsgAfterSave(info, "update");
                    }
                    // 3.更新使用信息表，最新检验信息
                    useInfoMapper.updateByRecord(record, jyjcInspectionResult.getNextInspectionDate(), jyjcInspectionResult.getInspectionType(), jyjcInspectionResult.getApplicationNo());
                    // 4.更新es下次检验日期
                    commonService.updateEquipNextInspectDate(jyjcInspectionResult, record);
                });
            } catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            // 5.新计算管道长度
            calAndWriteTotalPipelineLength(jyjcInspectionResult);
            // 6.发送数据刷新消息
            inspectionResultService.sendDataRefreshMsg(records);
        }
    }

    private void calAndWriteTotalPipelineLength(JyjcInspectionResult jyjcInspectionResult) {
        List<IdxBizJgTechParamsPipeline> allPipeLines = idxBizJgProjectContraptionMapper.selectPipelineListByProjectContraptionId(jyjcInspectionResult.getEquipUnicode());
        Double totalPipelineLength = allPipeLines.stream().map(IdxBizJgTechParamsPipeline::getPipeLength).filter(Objects::nonNull).map(this::parseToBigDecimal)
                .reduce(BigDecimal.ZERO, BigDecimal::add)
                .setScale(3, RoundingMode.HALF_UP).doubleValue();
        LambdaUpdateWrapper<IdxBizJgProjectContraption> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BaseEntity::getSequenceNbr, jyjcInspectionResult.getEquipUnicode());
        updateWrapper.set(IdxBizJgProjectContraption::getPipelineLength, totalPipelineLength);
        idxBizJgProjectContraptionMapper.update(null, updateWrapper);
    }

    private BigDecimal parseToBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        } catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }

    private void updateTechParams(Map<String, Object> e, String record) {
        JyjcInspectionResultServiceImpl.doUpdatePipelineTechParams(e, record, techParamPipelineMapper);
    }

}
