package com.yeejoin.amos.boot.module.elevator.biz.service.impl;


import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorSynLogDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.ElevatorSynLog;
import com.yeejoin.amos.boot.module.elevator.api.mapper.ElevatorSynLogMapper;
import com.yeejoin.amos.boot.module.elevator.api.service.IElevatorSynLogService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Date;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2025-03-28
 */
@Service
public class ElevatorSynLogServiceImpl extends BaseService<ElevatorSynLogDto, ElevatorSynLog, ElevatorSynLogMapper> implements IElevatorSynLogService {

    /**
     * 指定日期的更新日志
     * @param synDate  指定日期
     * @return 指定日期的同步记录
     */
    public ElevatorSynLog getOneBySynDate(Date synDate) {
        LambdaQueryWrapper<ElevatorSynLog> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ElevatorSynLog::getSynDate, DateUtil.formatDate(synDate));
        return this.getOne(queryWrapper);
    }

    /**
     * 获取最近的小于指定日期的最新日志
     * @param synDate 指定日期
     * @return 指定日期最近的同步记录
     */
    public ElevatorSynLog getOneBySynDateLess(Date synDate) {
        LambdaQueryWrapper<ElevatorSynLog> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.le(ElevatorSynLog::getSynDate, DateUtil.formatDate(synDate));
        queryWrapper.select(BaseEntity::getSequenceNbr,ElevatorSynLog::getVersion);
        queryWrapper.orderByDesc(ElevatorSynLog::getSynDate);
        queryWrapper.last("limit 1");
        return this.getOne(queryWrapper);
    }
}