package com.yeejoin.amos.boot.module.hygf.api.tdenginemapper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpower;
import com.yeejoin.amos.boot.module.hygf.api.entity.TdHYGFInverterMonthGenerate;
import com.yeejoin.amos.boot.module.hygf.api.entity.TdHYGFInverterTotalGenerate;
import com.yeejoin.amos.boot.module.hygf.api.entity.TdHYGFInverterYearGenerate;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface TdHYGFInverterYearGenerateMapper extends BaseMapper<TdHYGFInverterYearGenerate> {
    List<Map<String, Object>> selectYearTrend(String time, String snCode, String thirdStationId);

    List<Map<String, Object>> selectTotalTrend(String time, String snCode, String thirdStationId);

    Map<String, Object> selectYearTotal(String time, String snCode, String thirdStationId);
    List<TdHYGFInverterTotalGenerate> selectTotalSum(String time, String snCode, String thirdStationId);

    @UserEmpower(field ={"regional_companies_code"},dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"eq","in"} ,relationship="and")
    List<TdHYGFInverterYearGenerate> selectList(@Param(Constants.WRAPPER) Wrapper<TdHYGFInverterYearGenerate> queryWrapper);
}
