package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.feign.McbWarningFeign;
import com.yeejoin.amos.boot.module.jxiop.api.service.IMcbWarningService;
import com.yeejoin.amos.boot.module.jxiop.api.service.IPermissionService;
import com.yeejoin.amos.boot.module.jxiop.biz.mcbwarningmapper.McbWarningMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class McbWarningServiceImpl implements IMcbWarningService {

    @Autowired
    private McbWarningMapper mcbWarningMapper;

    @Autowired
    private IPermissionService permissionService;

    @Autowired
    private McbWarningFeign mcbWarningFeign;

    /**
     * 今日预警-预警总数
     *
     * @param processingStatus 处理状态
     * @return 总数信息
     */
    @Override
    public Map<String, Object> queryTodayCount(Integer processingStatus) {
        List<String> projectOrgCodes = this.getProjectOrgCodes();
        return mcbWarningMapper.queryTodayCount(projectOrgCodes, processingStatus);
    }

    /**
     * 近七日预警统计
     *
     * @return 预警统计
     */
    @Override
    public List<Map<String, Object>> queryWeekCount() {
        List<String> projectOrgCodes = this.getProjectOrgCodes();
        return mcbWarningMapper.queryWeekCount(projectOrgCodes);
    }

    /**
     * 预警信息列表
     *
     * @param page             分页
     * @param processingStatus 处理状态
     * @return 预警信息列表
     */
    @Override
    public Page<Map<String, Object>> queryWarningPage(Page<Map<String, Object>> page, Integer processingStatus, String eventLevel, String createDate, String warningSourceType) {
        List<String> projectOrgCodes = this.getProjectOrgCodes();
        long start = page.getCurrent() - 1;
        long offset = page.getSize() * page.getCurrent();
        List<Map<String, Object>> records = mcbWarningMapper.queryWarningList(start, offset, projectOrgCodes, processingStatus, eventLevel, createDate, warningSourceType);
        Long total = mcbWarningMapper.queryWarningCount(projectOrgCodes, processingStatus, eventLevel, createDate, warningSourceType);
        page.setRecords(records);
        page.setTotal(total);
        return page;
    }

    /**
     * 预警信息总数
     *
     * @param processingStatus 处理状态
     * @return 预警信息总数
     */
    @Override
    public Long queryWarningCount(Integer processingStatus, String eventLevel, String createDate, String warningSourceType) {
        List<String> projectOrgCodes = this.getProjectOrgCodes();
        return mcbWarningMapper.queryWarningCount(projectOrgCodes, processingStatus, eventLevel, createDate, warningSourceType);
    }

    /**
     * 问题信息列表
     *
     * @param page             分页
     * @param completionStatus 完成状态
     * @return 问题信息列表
     */
    @Override
    public Page<Map<String, Object>> queryQuestionPage(Page<Map<String, Object>> page, Integer completionStatus) {
        List<String> projectOrgCodes = this.getProjectOrgCodes();
        long start = page.getCurrent() - 1;
        long offset = page.getSize() * page.getCurrent();
        List<Map<String, Object>> records = mcbWarningMapper.queryQuestionList(start, offset, projectOrgCodes, completionStatus);
        Long total = mcbWarningMapper.queryQuestionCount(projectOrgCodes, completionStatus);
        page.setRecords(records);
        page.setTotal(total);
        return page;
    }

    /**
     * 问题信息列表
     *
     * @param completionStatus 完成状态
     * @return 问题信息列表
     */
    @Override
    public Long queryQuestionCount(Integer completionStatus) {
        List<String> projectOrgCodes = this.getProjectOrgCodes();
        return mcbWarningMapper.queryQuestionCount(projectOrgCodes, completionStatus);
    }

    /**
     * 获取地图点位/路线
     *
     * @param province 省份
     * @return 地图点位/路线
     */
    @Override
    public Object queryMapRoutes(String province) {
        List<String> projectOrgCodes = this.getProjectOrgCodes();
        // TODO: 远程调用warning服务
        return null;
    }

    /**
     * 任务详情分页列表
     */
    @Override
    public Page<Map<String, Object>> getTaskDetailPage(Map<String, Object> map) {
        map.put("GATEWAY_ID", String.format("[%s]", buildGateWayIdsParam()));
        FeignClientResult<Page<Map<String, Object>>> page = mcbWarningFeign.getTaskDetailPage(map);
        return page.getResult();
    }

    @Override
    public Page<Map<String, Object>> getQuestionRecordPage(Map<String, Object> map) {
        map.put("GATEWAY_ID", String.format("[%s]", buildGateWayIdsParam()));
        FeignClientResult<Page<Map<String, Object>>> page = mcbWarningFeign.getQuestionRecordPage(map);
        return page.getResult();
    }

    /**
     * 任务详情、问题记录左侧树
     *
     */
    @Override
    public Object getWarnTree(Map<String, Object> map) {
        map.put("GATEWAY_ID", String.format("[%s]", buildGateWayIdsParam()));
        FeignClientResult result = mcbWarningFeign.getWarnTree(map);
        return result.getResult();
    }

    /**
     * 任务详情列表统计
     *
     */
    @Override
    public Object getTaskDetailStatistic(Map<String, Object> map) {
        map.put("GATEWAY_ID", String.format("[%s]", buildGateWayIdsParam()));
        FeignClientResult result = mcbWarningFeign.getTaskDetailStatistic(map);
        return result.getResult();
    }

    /**
     * 问题记录统计
     *
     */
    @Override
    public Object getQuestionRecordStatistic(Map<String, Object> map) {
        map.put("GATEWAY_ID", String.format("[%s]", buildGateWayIdsParam()));
        FeignClientResult result = mcbWarningFeign.getQuestionRecordStatistic(map);
        return result.getResult();
    }

    /**
     * 获取用户权限(此处使用projectOrgCode)
     *
     * @return gatewayIds
     */
    private List<String> getProjectOrgCodes() {
        List<String> projectOrgCodes = permissionService.getCurrentUserProjectOrgCodes();
        if (Objects.isNull(projectOrgCodes)) {
            projectOrgCodes = Collections.emptyList();
        }
        return projectOrgCodes;
    }

    private String buildGateWayIdsParam() {
        List<String> currentUserPermissions = permissionService.getCurrentUserPermissions();
        if (Objects.isNull(currentUserPermissions)) {
            currentUserPermissions = new ArrayList<>();
        }
        String gatewayIds = String.join(",", currentUserPermissions);
        if (!gatewayIds.isEmpty()) {
            gatewayIds = String.format("[%s]", gatewayIds);
        }
        return Optional.ofNullable(gatewayIds).orElse("[]");
    }

}
