package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 分包商银行账户
 *
 * @author duanwei
 * @date 2020-09-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_company_acount")
@ApiModel(value = "CompanyAcount对象", description = "分包商银行账户")
public class CompanyAcount extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "部门id")
    private Long departmentId;

    @ApiModelProperty(value = "开户银行名称")
    private String bankName;

    @ApiModelProperty(value = "银行卡号")
    private String acountNumber;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "企业Id")
    private Long companyId;

    @ApiModelProperty(value = "分包商名称")
    private String companyName;

    @ApiModelProperty(value = "分包商名称")
    private String teamName;


}
