package com.yeejoin.amos.supervision.core.common.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class CheckReportParamDto implements Serializable {

    @ApiModelProperty(value = "报告名称")
    String name;

    @ApiModelProperty(value = "计划名称")
    String planName;

    @ApiModelProperty(value = "计划检查类型")
    String planCheckType;

    @ApiModelProperty(value = "检查级别")
    String checkLevel;

    @ApiModelProperty(value = "检查开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    Date startCheckTime;

    @ApiModelProperty(value = "检查结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    Date endCheckTime;

    @ApiModelProperty(value = "检查执行人")
    String checkUser;

    @ApiModelProperty(value = "组织机构代码")
    String orgCode;
}
