package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.datasync.entity.FireEquipmentFireAlarm;
import com.yeejoin.equipmanage.common.entity.EquipmentIndex;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarm;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarmLog;
import com.yeejoin.equipmanage.common.entity.dto.AlarmDTO;
import com.yeejoin.equipmanage.common.entity.dto.EquipSpecificAlarmDTO;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentIotAlarmVO;
import com.yeejoin.equipmanage.common.utils.CommonPageInfoParam;
import com.yeejoin.equipmanage.common.vo.EquipAlarmLineVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author keyong
 * @title: EquipmentSpecificAlarmMapper
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2020/10/30 18:15
 */
@Mapper
public interface EquipmentSpecificAlarmMapper extends BaseMapper<EquipmentSpecificAlarm> {

    /**
     * <pre>
     * @Description: 根据specificId查询
     * </pre>
     *
     * @MethodName:
     * @Param:
     * @Return: null
     * @Throws
     * @Author keyong
     * @Date 2020/11/3 19:18
     */
    List<EquipmentSpecificAlarm> getEquipmentSpecAlarmByIotCode(String iotCode);

    /**
     * <pre>
     * @Description: 查询wl_equipment_specific_alarm表是否存在报警记录
     * </pre>
     *
     * @MethodName:
     * @Param:
     * @Return: null
     * @Throws
     * @Author keyong
     * @Date 2020/11/3 19:31
     */
    int getCount(String iotCode);

    /**
     * <pre>
     * @Description: 查询符合条件的报警记录
     * </pre>
     *
     * @MethodName:
     * @Param:
     * @Return: null
     * @Throws
     * @Author keyong
     * @Date 2020/11/3 19:31
     */
    List<EquipmentSpecificAlarm> getEquipmentSpecAlarmVoListByEquipIndexId(@Param("equipmentIndex") EquipmentIndex equipmentIndex);

    /**
     * <pre>
     * @Description: 通过equipmentIndex查询符合条件的报警记录
     * </pre>
     *
     * @MethodName:
     * @Param:
     * @Return: null
     * @Throws
     * @Author keyong
     * @Date 2020/11/3 19:31
     */
    int checkIfExist(@Param("equipmentIndex") EquipmentIndex equipmentIndex);

    /**
     * <pre>
     * @Description: 通过iotCode查询符合条件的报警记录
     * </pre>
     *
     * @Throws
     * @Author keyong
     * @Date 2020/11/08 19:31
     */
    int checkIfExistByIotCode(@Param("iotCode") String iotCode);

    List<EquipmentSpecificAlarm> findEquipmentSpecificAlarmByEquipmentSpecificIdAndEquipmentIndexIdAndStatusIstrue(@Param("equipmentSpecificId") Long equipmentSpecificId
            , @Param("equipmentIndexId") Long equipmentIndexId);

    List<EquipmentSpecificAlarm> getAlarmByIotCode(@Param("iotCode") String iotCode);

    List<EquipmentSpecificAlarm> getAlarmByEquipmentSpecificIdAndEquipmentIndexId(@Param("equipmentSpecificIndexId") Long equipmentSpecificIndexId
            , @Param("equipmentIndexId") Long equipmentIndexId);

    /**
     * <pre>
     * @Description: 根据iotCode查询
     * </pre>
     *
     * @MethodName:
     * @Param:
     * @Return: null
     * @Throws
     * @Author keyong
     * @Date 2020/11/3 19:18
     */
    List<EquipmentIotAlarmVO> getEquipmentSpecAlarmByIot(String iotCode);

    /**
     * <pre>
     * @Description: 根据iotCode查询
     * </pre>
     *
     * @MethodName:
     * @Param:
     * @Return: null
     * @Throws
     * @Author keyong
     * @Date 2020/11/3 19:18
     */
    EquipmentSpecificAlarm getByIndexId(long indexId);

    List<EquipmentSpecificAlarm> getAlarmDataByIndexId(long indexId);

    List<EquipSpecificAlarmDTO> findByTypeAndDate(@Param("dto") EquipSpecificAlarmDTO dto);

    List<EquipSpecificAlarmDTO> findInfoByTypeAndDate(@Param("dto") EquipSpecificAlarmDTO dto);

    Page<Map<String, Object>> page(Page page, @Param("param") CommonPageInfoParam param);

    Page<Map<String, Object>> pageQuery(Page page, @Param("param") CommonPageInfoParam param);


    List<HashMap<String, Object>> getAlarmList(CommonPageInfoParam param);

    List<HashMap<String, Object>> getAlarmDetail(@Param("id") Long id, @Param("alarmType") String alarmType);

    List<Map<String, Object>> getEquipmentDetails(@Param("id") Long id, @Param("alarmType") String alarmType);

    int getEquipmentAlarmCount(@Param("id") Long id, @Param("alarmType") String alarmType);

    List<FireEquipmentFireAlarm> getFireEquipAlarmDetailsByAlarmId(@Param("list") List<Long> specificAlarmIds, @Param("indexIds") List<Long> equipIndexIds);

    Page<Map<String, Object>> pageAlarmsInfo(Page page, @Param("param") CommonPageInfoParam param);

    List<Map<String, Object>> getProObject(@Param("id") Long id);


    int getCountAlarmEquipment();

    int getCountEquipment();

    List<Map<String, Object>> getCountAlarm();

    Page<EquipSpecificAlarmDTO> getAlarmPage(Page page, @Param("dto") AlarmDTO dto);

    Page<EquipSpecificAlarmDTO> getEqPage(Page page, @Param("dto") AlarmDTO dto);

    List<EquipmentSpecificAlarmLog> getConfirmUser();

    EquipSpecificAlarmDTO getbyqrCode(@Param("code") String code);


    //各种类型统计
    Integer getcountAlarmtype(@Param("tyep") String tyep);

    //统计已处理和未处理
    Integer getcountAlarmHandle(@Param("tyep") String tyep);

    /**
     * <pre>
     * 根据装备id和查询指定状态告警数据
     * </pre>
     *
     * @param status
     * @param equipmentSpecificId
     * @return
     */
    List<EquipmentSpecificAlarm> getEquipListBySpecific(@Param("status") Boolean status, @Param("equipmentSpecificId") Long equipmentSpecificId);

    /**
     * 根据Code 和 indexKey 查设备是否报警
     * @param iotCode
     * @param indexKey
     * @param indexValue
     * @return
     */
    int selectCountByIotCode(@Param("iotCode") String iotCode, @Param("indexKey") String indexKey, @Param("indexValue") String indexValue);

    List<Map<String, Object>> equipStatusCount(HashMap<String, Object> hashMap);

    /**
     * 近一周告警趋势
     * @param hashMap
     * @return
     */
    List<EquipAlarmLineVo> equipAlarmLine(HashMap<String, Object> hashMap);
}
